
/* Generated by Interface Builder */

#import <appkit/nextstd.h>
#import "DefaultHandler.h"
#import <appkit/publicWraps.h>
#import <appkit/defaults.h>
#import <appkit/Matrix.h>
#import <appkit/Form.h>
#import <appkit/Cell.h>
#import <appkit/Button.h>
#import <strings.h>
extern id NXApp;

@implementation DefaultHandler

/*
 * The DefaultHandler object contains the data associated with sort
 * defaults,  and the routines that access them.
 */

+ initialize
{
static NXDefaultsVector Defaults= {
    {  "FieldSort",  "No" },
    {  "Separator", " " },
    {  "Start", "" },
    {  "End", "" },
    {NULL}
    };

    NXRegisterDefaults("AtYourService", Defaults);
    return self;
}

- writeDefaults:sender
{
    int useFields=(int) [inSwitch selectedCell];
    if (useFields) {
        const char *opt;
        NXWriteDefault("AtYourService", "FieldSort", "Yes");
        opt = [separator stringValue];
        if ( *opt ) {
            char sep[2];
            
            sep[0] = *opt;
            sep[1] = '\0';
            if ( strlen(opt) > 1 ) {
                [separator setStringValue:sep];
                NXBeep();
                }
            NXWriteDefault("AtYourService", "Separator", sep);
            }
        opt = [start stringValue];
        if ( *opt ) {
            char thisOption[100];
          /*
           * Sort asks for number of fields to skip,  we ask for
           * first significant field,  so we have to minus one here.
           */
            float startVal;
            startVal=[start floatValue];
            startVal--;
            sprintf(thisOption,"%g",startVal);
            NXWriteDefault("AtYourService", "Start", thisOption);
            }
        opt = [end stringValue];
        if ( *opt ) NXWriteDefault("AtYourService", "End", opt);
    }
    else NXWriteDefault("AtYourService", "FieldSort", "No");
    return self;
}

- readDefaults:sender
{
    int useFields;
    useFields=(strncmp(NXGetDefaultValue("AtYourService","FieldSort"),"Yes",3) == 0);
    [inForm setEnabled:useFields];
    [separator setEnabled:useFields];
    [inSwitch selectCellAt:useFields:0];
    
    [start setStringValue:NXGetDefaultValue("AtYourService","Start")];
    [end setStringValue:NXGetDefaultValue("AtYourService","End")];
    [separator setStringValue:NXGetDefaultValue("AtYourService","Separator")];
    
    // This method is called at startup.  Set up the entry types for the panel
    [start setEntryType:NX_FLOATTYPE];
    [end setEntryType:NX_FLOATTYPE];
    return self;
}

- changeState:sender
{
  /*
   * This method enables/disables the row selection based on whether
   * row-based sorting will be done
   */
    [inForm setEnabled:[inSwitch selectedRow]];
    [separator setEnabled:[inSwitch selectedRow]];
    return self;
}

- (char *) sortFields
{
  /*
   * Return the sort field information
   */
    char options[100];
    strcpy(options,"");
    if ( [inSwitch selectedRow] ) {
        const char *opt;
        opt = [separator stringValue];
        if ( *opt ) {
            char sep[2];
            
            sep[0] = *opt;
            sep[1] = '\0';
            strcat(options," -t");
            strcat(options,sep);
            if ( strlen(opt) > 1 ) {
                [separator setStringValue:sep];
                NXBeep();
                }
            }
        opt = [start stringValue];
        if ( *opt ) {
            char thisOption[100];
          /*
           * Sort asks for number of fields to skip,  we ask for
           * first significant field,  so we have to minus one here.
           */
            float startVal;
            startVal=[start floatValue];
            startVal--;
            sprintf(thisOption," +%g",startVal);
            strcat(options,thisOption);
            }
        opt = [end stringValue];
        if ( *opt ) {
            strcat(options," -");
            strcat(options,opt);
            }
        }
    return options;
}

- showPanel:sender
{
    [optionPanel makeKeyAndOrderFront:self];
    return self;
}
@end
