/* You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to
 * its fitness for any particular use.
 */

#import <appkit/Application.h>
#import <defaults.h>
#import <time.h>

#define LocalString(key, value, comment) doLocalString(NULL, key, value)
#define LocalStringFromTable(table, key, value, comment)      \
    doLocalString(#table, key, value)

extern id LoadLocalNib(const char *nibFile, id owner);

extern id LocalImage(const char *file);

extern void InitLocalDateAndTime();

extern void LocalDateAndTime(char *buffer,int  maxBufferSize, const time_t *time);
extern void LocalDate(char *buffer,int  maxBufferSize, const time_t *time);
extern void LocalTime(char *buffer,int maxBufferSize, const time_t *time);

extern const char *doLocalString(const char *stringTable, 
                                 const char *key, 
                                 const char *value);

/* Methods specific to AskMe app */
extern void getAppDirectory(char *appDirectory);
extern const char *findLocalDir();
