// 1/19/91
// The skeleton was generated by Interface Builder, the rest was inserted by Mike Mahoney.
// The lines that were inserted can be discovered by reading the comments. 

// The "printf" lines are for learning purposes only. They show that the "initFrame" method 
//	 is automatically invoked at launch time and that the "drawSelf" method is invoked as 
// 	 a result of the "display" method being invoked.   Do not invoke "drawSelf" directly. 
// Launch "SimpleGraphics" from a Shell window to see the output from the "printf"
//     statements.	(e.g. see the Shell output on page 73)

#import "SimpleView.h"			//  generated by IB
								
#import <appkit/Slider.h>			//  inserted because message sent to slider 
#import <dpsclient/wraps.h>		//  inserted for PS and NX graphics functions
		//  #import <appkit/appkit.h>  could be used here to import all app kit 
		//          interface (.h) files but would slow compilation considerably

@implementation SimpleView

#define   CIRCLE  1			//   #define(s)  and  declarations  inserted
#define   SQUARE  2

int  objectToDisplay = CIRCLE;	//  CIRCLE primitive displayed initially
int  fillFlag = 0;				//  no fill initially
float  sliderYvalue = 0.0;		//  primitive at the bottom of SimpleView initially


 			//  This method is automatically invoked when SimpleGraphics is launched.
-initFrame:(const NXRect *) frameRect	  //  this entire method was inserted
{
	printf ("Executing   'initFrame'  method \n");
	self = [super initFrame:frameRect];		//    create the SimpleView object
	return self;							//    some initialization may be put here
}


- displayCircle:sender	// We set up a target/action connection with this method in IB.
{					// IB generated the skeleton, the "guts" were inserted.
	printf ("Executing   'displayCircle'  \n");	//  these 3 lines were inserted
    	objectToDisplay = CIRCLE;
	[self display];				//  "display" message is sent to SimpleView object
								//   The "display" method sets up a drawing context
	return self;					//	and then invokes our "drawSelf" method.
}

- displaySquare:sender	   	//  very similar to the displayCircle method above
{
	printf ("Executing   'displaySquare'  \n");
	objectToDisplay = SQUARE;
	[self display];
	return self;
}

- fillToggle:sender		// We set up a target/action connection with this method in IB.
{					// IB generated the skeleton, the "guts" were inserted.
	printf ("Executing   'fillToggle'  \n");
	fillFlag = !fillFlag;					//  toggle the fill flag (inserted)
	[self display];
	return self;
}

- sliderMoved:sender	// We set up a target/action connection with this method in IB.
{					// IB generated the skeleton, the "guts" were inserted.
	printf ("Executing   'sliderMoved'  \n");
	sliderYvalue = [sender floatValue];		//  read slider value from slider object
	[self display];							//      (the "sender" of the message
	return self;							//       which invokes this method)
}

			//  The drawSelf::  method is invoked when SimpleGraphics is launched.
			//  It is also invoked whenever  [self display]  messages are sent.
-drawSelf:(NXRect *)rects :(int) rectCount        //  This entire method was inserted.
{				
	printf ("Executing   'drawSelf' \n \n");
    							//   The "PS" functions are Display PostScript functions.
							//   The NX functions are NeXTstep graphics functions.
        PSsetgray (NX_WHITE);	//   set the drawing color to white
        NXRectFill (&bounds);		//   fill the entire SimpleView with a white rectangle
						//   "bounds" is a C struct  containing SimpleView's dimensions
        PSsetgray (NX_BLACK);      //   set the drawing color to black
        NXFrameRect(&bounds);	//   draw a black boundary around all of SimpleView

        PSnewpath(); 
        PSsetlinewidth (3.0);
    
        switch  (objectToDisplay)   {			//   display a circle or square depending 
									//     on the value of "objectToDisplay"    
            case CIRCLE:	    PSarc (bounds.size.width/2.0 , sliderYvalue,
					                40.0, 0.0, 360.0);       //  radius is 40.0
				            break;
  
            case SQUARE:	    PSmoveto (bounds.size.width/2.0 - 40.0 , sliderYvalue - 40.0);
         		                    PSrlineto (0.0, 80.0);
         		                    PSrlineto (80.0, 0.0);	         //  relative line draws
         		                    PSrlineto (0.0, -80.0);
					    PSclosepath();
     			                    break;  			
        }       /*  end switch  */
    		    
	if   (fillFlag)	PSfill();		//  "paint" the enclosed area on the screen
	else   		PSstroke();	//  "paint" the path on the screen
    
      return self;
      
}   /* end drawSelf */

@end
