// Copyright (C) 1989 Jacob Gore
// 
// This file is part of GNULicense, a package to ease the inclusion
// of the GNU General Public License into NextStep applications.
// 
//     This program is free software; you can redistribute it and/or modify
//     it under the terms of the GNU General Public License as published by
//     the Free Software Foundation; either version 1, or (at your option)
//     any later version.
// 
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
// 
//     You should have received a copy of the GNU General Public License
//     along with this program; if not, write to the Free Software
//     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
//     or send electronic mail to Jacob Gore <jacob@gore.com>.

// The code to print the License leaves much to be desired.  I have left my
// most successful attempts at providing the user with the printing interface
// that is supposed to be the norm on the NeXT (put up a PrintPanel, etc.) in
// this file, commented out.  If anybody can do it right, please send me the
// code!
//
// Jacob Gore <jacob@gore.com>

#import "GNULicense.h"
#import <appkit/appkit.h>
#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <appkit/PrintPanel.h>
#import <appkit/PrintInfo.h>
#import <appkit/Speaker.h>
#import <appkit/TextField.h>
#import <stdio.h>
#import <string.h>
#import <stdlib.h>
#import <syslog.h>

@implementation GNULicense

+ new
{
    self = [super new];
    [NXApp loadNibSection:"GNULicense.nib" owner:self];
    [panel setMiniwindowIcon:"app"];
    return self;
}

- showLicense:sender
{
    [panel makeKeyAndOrderFront:sender];
    return self;
}

// The original intention of this version of -printLicense: was to let
// WriteNow print it.  I was hoping that I could just send -msgPrint:ok: to
// port "WriteNow", and WriteNow would either just print it with default
// user choices, or, better yet, put up a PrintPanel for the user.
//
// It appears that WriteNow does not respond to -msgPrint:ok: at all...
// so, I just make WriteNow open the file, and I ask the user to do the
// printing from WriteNow.  Yuck.
// -- Jacob
//
- (int)printLicenseFile:(const char*)fullFileName
{
    int retCode;
    int ok = (int)NO;

    [NXApp deactivateSelf];
    retCode = [speaker openFile:fullFileName ok:&ok];
    if (retCode != 0) {
	NXRunAlertPanel(NULL, "Cannot connect to WriteNow",
			"Cancel", NULL, NULL);
	return -2;	// Tell NXFilePathSearch to quit at this point
    } else if (!ok) {
	return 1;	// Tell NXFilePathSearch to continue searching
    } else {
	return -2;	// Tell NXFilePathSearch to quit at this point
    }
}

static int
printLicenseFile(const char *fullFileName, void *self)
{
    return [(GNULicense*)self printLicenseFile:fullFileName];
}

- printLicense:sender
{
    int response;
    response = NXRunAlertPanel("Sorry to bother you",
			       "I will make WriteNow open the License "
			       "document. Please print it from there.",
			       NULL, "Cancel", NULL);
    if (response == NX_ALERTDEFAULT) {

	int port = NXPortFromName("WriteNow", NULL);

	if (port == PORT_NULL) {
	    NXRunAlertPanel(NULL, "Cannot connect to WriteNow",
			    "Cancel", NULL, NULL);
	} else {

	    const char *searchPath =
	      "~/Library/GNU:/LocalLibrary/GNU:/NextLibrary/GNU:.";
	    const char *fileName = "GNULicense.wn";
	    int retCode;

	    speaker = [Speaker new];
	    [speaker setSendPort:port];

	    retCode = NXFilePathSearch(NULL, searchPath, YES, fileName,
				       printLicenseFile, (void*)self);
	    if (retCode != -2) {
		syslog(LOG_ERR,
		       "Readable file \"%s\" not found in path \"%s\"",
		       fileName, searchPath);
		NXRunAlertPanel(NULL, "I cannot find file GNULicense.wn.",
				"Cancel", NULL, NULL);
	    }
	}
    }
    return self;
}

// Could not get this version to work:
//
//   1.	Save button on PrintPanel does not return to this code, but instead
//	saves "what has been spooled".  I cannot figure out how to make the
//	postscript file to be the "what has been spooled".
//
//   2.	If you select a page range to preview, Preview chokes on the output
//	of psrev that it gets.
//
// Close, but no banana.
// -- Jacob
//
// - printLicense:sender
// {
//     int pickedButtonTag;
//     PrintPanel *printPanel;
// 
//     printPanel = [PrintPanel new];
//     pickedButtonTag = [printPanel runModal];
//     [printPanel orderOut:self];
// 
//     if (pickedButtonTag == NX_CANCELTAG) {
// 
// 	return self;
// 
//     } else {
// 
// 	const char *fileName = "/LocalLibrary/GNU/GNULicense.ps";
// 	char spoolFileName[] = "/tmp/GNULicenseXXXXXX.ps";
// 	PrintInfo *printInfo;
// 	const char *psrevCommandFormat = "psrev%s%s %s > %s";
// 	char *psrevCommand;
// 	BOOL allPages;
// 	char psrevPagesOption[32];
// 	char *psrevReverseOption;
// 
// 	// Use psrev to create a spool file
// 
// 	printInfo = [NXApp printInfo];
// 
// 	if ([printInfo isAllPages]) {
// 	    psrevPagesOption[0] = '\0';
// 	} else {
// 	    sprintf(psrevPagesOption, " -s%d-%d",
// 		    [printInfo firstPage], [printInfo lastPage]);
// 	}
// 
// 	if ([printInfo pageOrder] == NX_DESCENDINGORDER) {
// 	    psrevReverseOption = "";	// psrev reversed by default
// 	} else {
// 	    psrevReverseOption = " -R";
// 	}
// 
// 	NXGetTempFilename(spoolFileName,
// 			  strchr(spoolFileName, 'X')-spoolFileName);
// 
// 	psrevCommand = malloc(strlen(psrevCommandFormat)-8 +
// 			      strlen(psrevPagesOption) +
// 			      strlen(psrevReverseOption) +
// 			      strlen(fileName) +
// 			      strlen(spoolFileName) +
// 			      1);
// 
// 	if (psrevCommand) {
// 	    int result;
// 	    sprintf(psrevCommand, psrevCommandFormat,
// 		    psrevPagesOption, psrevReverseOption,
// 		    fileName, spoolFileName);
// 
// 	    result = system(psrevCommand);
// 	    if (result != 0) {
// 		// ???
// 	    }
// 	    free(psrevCommand);
// 	} else {
// 	    // ???
// 	}
// 
// 	[printInfo setOutputFile:spoolFileName];
// 
// 	// Now do something with the spool file
// 
// 	switch (pickedButtonTag) {
// 	  case NX_PREVIEWTAG:
// 	    {
// 		port_t port;
// 		int openedOk;
// 
// 		port = NXPortFromName("Preview", NULL);
// 		if (port == PORT_NULL) {
// 		    // ???
// 		} else {
// 		    int retCode;
// 		    Speaker *speaker = [Speaker new];
// 		    [speaker setSendPort:port];
// 		    retCode = [speaker openTempFile:spoolFileName
// 			                         ok:&openedOk];
// 		    if (retCode != 0 || !openedOk) {
// 			// ???
// 		    }
// 		    [speaker free];
// 		}
// 	    }
// 	    break;
// 	  case NX_OKTAG:
// 	    {
// 		const char *printCommandFormat = "lpr -sr%s%s %s";
// 		              // "-sr" will delete the file after it is printed
// 		int copies;
// 		char *printCommand;
// 		char printCopiesOption[16];
// 		char *printPrinterOption;
// 		const char *printerName;
// 
// 		copies = [printInfo copies];
// 		if (copies > 1) {
// 		    sprintf(printCopiesOption, " -#%d", copies);
// 		} else {
// 		    printCopiesOption[0] = '\0';
// 		}
// 
// 		printerName = [printInfo printerName];
// 		if (printerName) {
// 		    printPrinterOption = malloc(strlen(printerName) +
// 						4 /* room for " -P" & '\0' */);
// 		    sprintf(printPrinterOption, " -P%s", printerName);
// 		} else {
// 		    printPrinterOption = malloc(1);	// so that free() works
// 		    *printPrinterOption = '\0';
// 		}
// 
// 		if (printerName == NULL) {
// 		    // ???
// 		}
// 
// 		printCommand = malloc(strlen(printCommandFormat)-6 +
// 				      strlen(printCopiesOption) +
// 				      strlen(printPrinterOption) +
// 				      strlen(spoolFileName) +
// 				      1);
// 		if (printCommand) {
// 		    int result;
// 		    sprintf(printCommand, printCommandFormat,
// 			    printCopiesOption, printPrinterOption,
// 			    spoolFileName);
// 		    result = system(printCommand);
// 		    if (result != 0) {
// 			// ???
// 		    }
// 		    free(printCommand);
// 		} else {
// 		    // ???
// 		}
// 	    }
// 	    break;
// 	  case NX_SAVETAG:
// 	    {
// 		fprintf(stderr, "%s\n", [printInfo outputFile]);
// 		unlink(spoolFileName);
// 	    }
// 	    break;
// 	}
//     }
//     return self;
// }

- setPanel:anObject
{
    panel = anObject;
    return self;
}

@end
