/*
 * Dviinfo v1.1 1991-93 by Valentino Kyriakides.
 * In v1.1 added page metric options and a man-page.
 * Compile: "cc -o dviinfo dviinfo.c ; strip dviinfo".
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define banner 		"\nThis is dviinfo v1.1 for the NeXT\n 1991-93 by Valentino Kyriakides\n\n"
#define error(a)	{fprintf(stderr, a); exit(1);}
#define post		248
#define post_post	249
#define dvi_id		2
#define nop			138
#define fnt_def1	243
#define fnt_def2	244
#define fnt_def3	245
#define fnt_def4	246

typedef unsigned long four_bytes;

int cur_command;
double unity;
char **getargv;

void print_dimen(four_bytes x)
{
	double val;
	char *unity_name;
	
	val = unity*x / 10000.0;
	if (getargv[1][0] == '-')
	{
		switch (getargv[1][1])
		{
			default:
			case 'c':	if (val > 10)
						{
							unity_name = "cms";
							val /= 10;
						}
						else
							unity_name = "mm";
						break;
			case 'i':	val /= 10;
						val = val * 0.3937;
						unity_name = "inches";
						break;
			case 'p':	val /= 10;
						val = val * 28.346;
						unity_name = "points";
						break;
			case 'P':	val /= 10;
						val = val * 2.3623;
						unity_name = "picas";
						break;
		}
	} else {
		if (val > 10)
		{
			unity_name = "cms";
			val /= 10;
		}
		else
			unity_name = "mm";
	}
	printf("%5.2f %s", val, unity_name);
}


FILE *dvi_file;

four_bytes read_unsigned(int bytes)
{
	four_bytes x;
	
	x = getc(dvi_file);
	while (bytes-- >1)
	{
		x *= 256;
		x += getc(dvi_file);
	}
	return(x);
}


int reverse_getc(void)
{
	fseek(dvi_file, -2, SEEK_CUR);
	return(getc(dvi_file));
}


void process_dvi_file(void)
{
	four_bytes design_size, at_size;
	four_bytes num, den, magnification;
	four_bytes page_width, page_height;
	int		   a, l, pages;
	double	   font_size;
	fpos_t	   post_loc;	
	
	
	fseek(dvi_file,0,SEEK_END);								   /* Dateiende */
													/* Fvllbytes ignorieren */
	while ((cur_command = reverse_getc()) == 223)
		;
	if (cur_command != dvi_id)
		error("Wrong id-Byte in postamble");
										   /* rvckwYrts bis post_post lesen */
	reverse_getc(); reverse_getc(); reverse_getc();
	reverse_getc();	cur_command = reverse_getc();
	if (cur_command != post_post)
		error("Postamble not found");
	post_loc = (fpos_t)read_unsigned(4);
												  /* Zur Postamble springen */
	if (fseek(dvi_file,post_loc,SEEK_SET) != 0)
		error("Seek error, `postamble' not found");
	if ((cur_command = (int) read_unsigned(1)) != post)
		error("Postamble not found");
	read_unsigned(4);
									  /* Zeiger auf begin der letzten Seite */
	num = read_unsigned(4);  den = read_unsigned(4);
	magnification = read_unsigned(4);
	unity = (num*((double) magnification/1000))/den;
	page_height = read_unsigned(4);
	page_width = read_unsigned(4);
	read_unsigned(2);							   /* Stackgrp{e ignorieren */
	pages = (int) read_unsigned(2);
	printf("The dvi-file contains %d pages.\n", pages);
	printf("Each page is ");
	print_dimen(page_width); printf(" wide und ");
	print_dimen(page_height); printf(" high.\n\n");
	printf("The DVI-file needs the following fonts: \n\n");
	while (cur_command != post_post)
	{
		cur_command = (int) read_unsigned(1);
		switch (cur_command)
		{
			case nop:
			case post_post : break;
			case fnt_def1 :
			case fnt_def2 :
			case fnt_def3 :
			case fnt_def4 :
				read_unsigned(cur_command-fnt_def1+1);
				read_unsigned(4);					 /* Prvfsumme wegwerfen */
				at_size = read_unsigned(4);
				design_size = read_unsigned(4);
				a = (int) read_unsigned(1);
				l = (int) read_unsigned(1);
				while (a-- > 0)
					putc(getc(dvi_file), stdout);
				putc(':', stdout);
				while (l-- > 0)
					putc(getc(dvi_file), stdout);
				font_size = (at_size*((double)magnification/1000))/design_size;
				printf(" at magstep %5.3f\n", font_size);
				break;
			default : error("Illegal command");
		}
	}
}


int main(int argc, char **argv)
{
	fputs(banner, stderr);
        getargv = argv;
	if (argc < 2)
	{
		fprintf(stderr,"Usage: %s [-c | -i | -p | -P] [dvi-file]\n", *argv);
		fprintf(stderr,"Where: \n");
		fprintf(stderr,"\t -c \t show page layout in cms (default)\n");
		fprintf(stderr,"\t -i \t show page layout in inches \n");
		fprintf(stderr,"\t -p \t show page layout in points \n");
		fprintf(stderr,"\t -P \t show page layout in picas \n");
		return(1);
	}
	argv++;  
	if (argc == 3)
		argv++;
	dvi_file = fopen(*argv, "rb");
	if (dvi_file == NULL)
	{
		fprintf(stderr,"Can't open DVI-file %s \n", *argv);
		return(1);
	}
	process_dvi_file();
	return(0);
}
