/*
 * xvxpm.c - load routine for X11 XPM v3 format pictures
 *
 * LoadXPM(fname,nc)
 * WriteXPM(fp,pic,w,h,rp,gp,bp,nc,cs,n)
 */

/*
 * Written by Sam Yates (syates@spam.maths.adelaide.edu.au)
 * to support xpm v3 format.
 *
 * Uses hcreate etc. caus' I'm lazy :)
 */

#include <search.h>
#include "xv.h"

static int XPMError();
unsigned char htoc();

int LoadXPM(fname,nc)
char *fname;
int   nc;
{
  FILE *fp;
  char inlin[256];
  char c;
  int stage,instr,so,i,xwidth,ywidth,yw,cpp,nce;
  char *pix,*pic24,*pvla,*line,*lp,*plp,*cp;
  ENTRY item,*hp;
  XColor col1,col2;

  fp=fopen(fname,"r");
  if (!fp) return 1;

  /* Read in strings one at a time and parse.
     Stop when get to expected end or unexpected EOF */

  SetDirRButt(F_FORMAT, F_XPM);
  SetISTR(ISTR_FORMAT,"XPM v3");

  stage=0; /* searching for value string */
  instr=0; /* not inside a string */
  while (stage<3&&(c=getc(fp))) {
    if (!instr&&c!='"') continue;
    if (!instr) instr=1,so=0;
    else if (c=='"'||(so==255&&stage==0)||(so==xwidth*(cpp+1)&&stage==2)) {
      while (c!='"'&&(c=getc(fp))) ;
      instr=0;
      switch (stage) {
      case 0:
        inlin[so]=0;
        sscanf(inlin,"%d%d%d%d",&xwidth,&ywidth,&nce,&cpp);
        yw=ywidth;
        stage++;
        if (nce<=0||cpp<=0) return(XPMError("No colours in XPM?"));
        hdestroy();
        if (!hcreate(nce))
          return(XPMError("Insufficient memory for colour table"));
        if (!(line=malloc(xwidth*(cpp+1)))||!(pvla=malloc(nce*(cpp+5)))||
            !(pic24=malloc(xwidth*ywidth*3)))
          return(XPMError("Insufficient memory for X pixmap"));
        pix=pic24;
        break;
      case 1:
        inlin[so]=0;
        memcpy(pvla,inlin,cpp);
        memcpy(pvla+cpp,"\0\0\0\0\0",5);
        if (so>cpp+1) {
          cp=strtok(inlin+cpp+1,"\t ");
          plp=0;
          do {
            if (*cp=='s') {strtok(0,"\t "); continue;}
            lp=strtok(0,"\t ");
            if (*cp=='c') plp=lp;
          } while (cp=strtok(0,"\t "));
          if (plp) lp=plp;
          if (lp) {
            if (*lp=='#') {
              pvla[cpp+1]=htoc(lp+1);
              pvla[cpp+2]=htoc(lp+3);
              pvla[cpp+3]=htoc(lp+5);
            } else if (XLookupColor(theDisp,theCmap,lp,&col1,&col2)) {
              pvla[cpp+1]=col1.red>>8;
              pvla[cpp+2]=col1.green>>8;
              pvla[cpp+3]=col1.blue>>8;
            }
          }
        }
        hsearch((item.key=pvla,item.data=pvla+cpp+1,item),ENTER);
        pvla+=cpp+5;
        if (--nce<=0) stage++;
        break;
      case 2: 
        for (i=0;i<xwidth;i++) {
          hp=hsearch((item.key=line+i*(cpp+1),item),FIND);
          if (!hp) *pix++=*pix++=*pix++=0;
          else memcpy(pix,hp->data,3),pix+=3;
        }
        if (--yw<=0) stage++;
      default : ;
      }
    } else {
      if (stage<2) inlin[so++]=c;
      else {
        line[so++]=c;
        if (!((so+1)%(cpp+1))) line[so++]=0;
      }
    }
  }
  if (Conv24to8(pic24,xwidth,ywidth,nc))
    return(XPMError("Couldn't convert to 8 bit"));
  hdestroy();
  free(pic24); free(line); free(pvla);

  if (fp!=stdin) fclose(fp);
  return 0;
}  


static int XPMError(st)
char *st;
{
  SetISTR(ISTR_WARNING,st);
  return 1;
}

unsigned char htoc(s)
char *s;
{
  unsigned char i;
  if ('0'<=*s&&*s<='9') i=(*s-'0')<<4;
  else if ('a'<=*s&&*s<='f') i=(*s-'a'+10)<<4;
  else if ('A'<=*s&&*s<='F') i=(*s-'A'+10)<<4;
  s++;
  if ('0'<=*s&&*s<='9') return i+*s-'0';
  else if ('a'<=*s&&*s<='f') return i+*s-'a'+10;
  else if ('A'<=*s&&*s<='F') return i+*s-'A'+10;
  return i;
}

WriteXPM(fp,pic,w,h,rp,gp,bp,nc,cs,n)
FILE *fp;
byte *pic;
int w,h;
byte *rp,*gp,*bp;
int nc,cs;
char *n;
{
  int i,j;
  byte c,*pix=pic;
  char name[256];

  strncpy(name,n,255);
  name[255]=0;
  i=strspn(name,"_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  if (!i||'9'>=*name) strcpy(name,"xpm"); else name[i]=0;

  fprintf(fp,"/* XPM */\nstatic char* %s = {\n\"%d %d %d 2\",\n",name,w,h,nc);
  if (cs!=F_GREYSCALE)
    for (i=0;i<nc;i++) fprintf(fp,"\"%c%c c #%02x%02x%02x\",\n",'_'+(i>>5),'_'+(i%32),rp[i],gp[i],bp[i]);
  else
    for (i=0;i<nc;i++) {
      c=MONO(rp[i],gp[i],bp[i]);
      fprintf(fp,"\"%c%c c #%02x%02x%02x\",\n",'_'+(i>>5),'_'+(i%32),c,c,c);
    }
  for (i=0;i++<h;) {
    fputc('"',fp);
    for (j=0;j++<w;pix++) fputc('_'+(*pix>>5),fp),fputc('_'+(*pix%32),fp);
    fputs("\",\n",fp);
  }
  if (fputs("} ;\n",fp)==EOF) return 1; else return 0;
}
  
