#ifdef NeXT
#include <sound/soundstruct.h>
#include <sys/stat.h>
# define HEADER_SIZE 28
# define INFO_SIZE 4
# else 
#if defined(SPARC_AUDIO)
#include <multimedia/audio_filehdr.h>
# define HEADER_SIZE 24
# define INFO_SIZE 0
#endif
#endif

/* special case if working on multi-architecture system */
/* files are read in as NeXT files (headersize == 28)       */
#if defined(USE_NeXT_HEADERS) && !defined(NeXT)
# undef HEADER_SIZE
# undef INFO_SIZE
# define HEADER_SIZE 28
# define INFO_SIZE 4
#endif

# define NeXT_STYLE_HEADER (defined(NeXT) || defined(SPARC_AUDIO))
# define SIZEOF_BSD_HEADER 1024

# define HYBRID_TYPE 0
# define NATIVE_TYPE 1
# define IRCAM_TYPE 2

# define SF_MAGIC 107364
# define SF_LINK 107414
# define SF_CODEC sizeof(char)
# define SF_SHORT sizeof(short)
# define SF_FLOAT sizeof(float)
# define SF_BUFSIZE	(16*1024)
# define SF_MAXCHAN	4
# define MAXCOMM 512
# define MINCOMM 256

/* Codes for sfcode */
# define SF_END 0
# define SF_MAXAMP 1
# define SF_COMMENT 2
# define SF_LINKCODE 3

typedef struct sfcode {
	short	code;
	short	bsize;
} SFCODE;

typedef struct sfmaxamp {
	float	value[SF_MAXCHAN];
	long	samploc[SF_MAXCHAN];
	long	timetag;
} SFMAXAMP;

typedef struct sfcomment {
	char 	comment[MAXCOMM];
} SFCOMMENT;

typedef struct sflink {
	char 	reality[50];
	int 	startsamp;
	int	endsamp;
} SFLINK;

/* this is a generic header for either NeXT or Sparc files */

#if NeXT_STYLE_HEADER
typedef struct local_header {
	int magic;
	int data_loc;
	int data_size;
	int format;
	int samp_rate;
	int nchans;
#if defined(NeXT) || defined(USE_NeXT_HEADERS)
	char info[4];
#endif
} LOCALHEADER;

typedef union ircamheader {
	struct {	
		int	  sf_magic;
		float	  sf_srate;
		int	  sf_chans;
		int	  sf_packmode;
		char	  sf_codes;
	} sfinfo;
	char	filler[SIZEOF_BSD_HEADER];
} IRCAMHEADER;

#endif	/* NeXT_STYLE_HEADER */

typedef union sfheader {
	struct {	
#if NeXT_STYLE_HEADER
		LOCALHEADER lheader;
#endif 
		int	  sf_magic;
		float	  sf_srate;
		int	  sf_chans;
		int	  sf_packmode;
		char	  sf_codes;
	} sfinfo;
	char	filler[SIZEOF_BSD_HEADER];
} SFHEADER;

# define sfchans(x) (x)->sfinfo.sf_chans
# define sfmagic(x) (x)->sfinfo.sf_magic
# define sfsrate(x) (x)->sfinfo.sf_srate
# define sfclass(x) (x)->sfinfo.sf_packmode

# define ismagic(x) ((x)->sfinfo.sf_magic == SF_MAGIC)
# define islink(x)  ((x)->sfinfo.sf_magic == SF_LINK)

# define sfmaxamp(mptr,chan) (mptr)->value[chan]
# define sfmaxamploc(mptr,chan) (mptr)->samploc[chan]

# define sfcomm(x,n) (x)->comment[n]

# define sfoffset(x,h) ((x)->startsamp * sfchans(h) * sfclass(h))
# define sfendset(x,h) ((x)->endsamp * sfchans(h) * sfclass(h))

# define sflseek(x,y,z) lseek(x,z != 0 ? y : (y) + sizeof(SFHEADER),z)
