/* 
	graphpoints.h
*/

typedef struct pointlink {
	int xval;
	double yval;
	struct pointlink *prev;
	struct pointlink *next;
} Pt_link;

typedef struct mygraph {
	Pt_link **pointlist;	/* linked list pointers */
	int npoints;
	int maxpoints;
	int nchans;
/* private functions */
	int (*extendList)();
/* public functions */
	Pt_link *((*addPoint)());
	Pt_link *((*getPoint)());
	Pt_link *((*previous)());
	Pt_link *((*next)());
	Pt_link *((*last)());
	Pt_link *((*head)());
	void (*destroy)();
} Graph_points;

typedef struct myiter {
	Pt_link *current;
/* public functions */
	Pt_link *((*next)());
	void (*destroy)();
} Graph_iter;

typedef struct myadder {
	Pt_link *current;
/* public functions */
	Pt_link *((*add)());
	void (*destroy)();
} Graph_adder;

int gp_extendList();

void gp_destroy(), gi_destroy(), ga_destroy();
Pt_link *gp_previous(), *gp_next(), *gp_getPoint(), *gp_head(), *gp_last();
Pt_link *gi_next(), *ga_add(), *gp_addPoint();

struct mygraph *new_graphpoints();
struct myiter *set_iter();
struct myadder *set_adder();
