
/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/* dialog.c -- the default values for all the dialog windows used in
   mixview.
		Douglas Scott 2/89
*/

#include "main.h"
#include "dialog.h"
#include "windows.h"
#include "soundfile.h"
#include <ctype.h>
#include "nobug.h"
#include "alert.bitmap"
#include "query.bitmap"

#if defined(NeXT) || defined(USE_NeXT_HEADERS)
#define NATIVE "Native NeXT"
#define HYBRID "BSD/NeXT"
#else
#if defined(sparc) || !defined(USE_NeXT_HEADERS)
#define NATIVE "Native SPARC"
#define HYBRID "BSD/SPARC"
#endif
#endif

extern sf_struct *v;
extern Display *dpy;
extern Window dwin, mixwin;
extern VPFun default_button_proc;
extern unsigned long myfg, mybg;
extern FLAG is_visible;
extern char *progname;

void set_channel_vals();

Dialog *dialog;	/* this is global to entire program */
int errnum;	/* my error flag */
XImage *alert_icon, *query_icon, *image_create();

static char *chanlist[] = {"0", "1", "2", "3", 0};
static char *modelist[] = {"fixed", "curve", 0};
static char *fftlist[] = {"64  ", "128 ", "256 ", "512 ", "1024", "2048", 0};

setup_dialogs()
{
	Window root = DefaultRootWindow(dpy);
	dialog = new_dialog_list(dialog, root);
	alert_icon = image_create(dpy, myfg, mybg, alert_bits, 24, 24, 
		DefaultDepth(dpy, DefaultScreen(dpy)));
	query_icon = image_create(dpy, myfg, mybg, query_bits, 24, 24, 
		DefaultDepth(dpy, DefaultScreen(dpy)));
}

/* some convenience functions */

void
mv_alert(string)
	char *string;
{
	if(is_visible)
		(void) dialog->call(dialog, D_ALERT, string);
	else fprintf(stderr, "%s\n", string);
}

void
mv_error(err, string)
	int err;
	char *string;
{
	if(is_visible) {
		errnum = err;
		(void) dialog->call(dialog, D_ERROR, string);
	}
	else {
		fprintf(stderr, "%s\n", string);
		errno = err;
		perror("mixview");
	}
}

void
mv_die(err, string)
	int err;
	char *string;
{
	if(is_visible) {	/* print to stderr in case windows fail */
		fprintf(stderr, string);
		fprintf(stderr, "\n");
	}
	if(err) mv_error(err, string);
	else mv_alert(string);
	exit(-1);
}

int
mv_query(string)	/* one string, yes, no, or cancel answers */
	char *string;
{
	int code = dialog->call(dialog, D_QUERY, string);
	return code;
}

Dialog_win *
dlist_newDialog(dlist, d_index)
Dialog *dlist;
int d_index;
{
	void confirm(), deny(), cancel();
	int check_val(), check_txt();
	unsigned dframe_smht = 200, dframe_medht = 300, dframe_lrght = 375;
	int x, y, button_xloc = 200;
	int button_sm_yloc = 150, button_med_yloc = 250;
	int button_lrg_yloc = 300;
	int _2button1_xloc = 50, _2button2_xloc = 350;
	int _3button1_xloc = 20, _3button2_xloc = 200, _3button3_xloc = 380;
	Dialog_win *dw;
	Panel_item *item;
	Window root = DefaultRootWindow(dpy);
	unsigned dbw = 2;
	/* position relative to root */
	get_win_coords(mixwin, &x, &y);
	x += 100;
	y += 100;
	
	switch(d_index) {
	/* two passed strings and one button */
	case D_ALERT:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw); 
	dw->addLabel(dw->panel,  20, 80, "", "label 1");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, alert_icon);
	dw->addButton(dw->panel, button_xloc, 150, " okay ", confirm);
	break;

	case D_ERROR:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw); 
	dw->addLabel(dw->panel,  20, 70, "", "label 1");
	dw->addLabel(dw->panel,  20, 90, "", "label 2");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, alert_icon);
	dw->addButton(dw->panel, button_xloc, 150, " okay ", confirm);
	break;

	/* two labels and one button */
	case D_2L1B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "", "label 1");
	dw->addLabel(dw->panel,  20, 45, "", "label 2");
	dw->addButton(dw->panel, button_xloc, 150, " okay ", confirm);
	break;
	
	/* one label and two buttons */
	case D_1L2B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 70, "", "label 1");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, query_icon);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, " yes ", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, " no ", deny);
	break;
	
	/* two labels and two buttons */
	case D_2L2B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "", "label 1");
	dw->addLabel(dw->panel,  20, 45, "", "label 2");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, query_icon);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	/* two labels and three buttons */
	case D_2L3B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "", "label 1");
	dw->addLabel(dw->panel,  20, 45, "", "label 2");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, query_icon);
	dw->addButton(dw->panel, _3button1_xloc, button_sm_yloc, " yes ", confirm);
	dw->addButton(dw->panel, _3button2_xloc, button_sm_yloc, " no ", deny);
	dw->addButton(dw->panel, _3button3_xloc, button_sm_yloc, "cancel", cancel);
	break;

	/* three labels and two buttons */
	case D_3L2B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "", "label 1");
	dw->addLabel(dw->panel,  20, 45, "", "label 2");
	dw->addLabel(dw->panel,  20, 70, "", "label 3");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, query_icon);
	dw->addButton(dw->panel, _3button1_xloc, button_sm_yloc, " yes ", confirm);
	dw->addButton(dw->panel, _3button3_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	/* three labels and three buttons */
	case D_3L3B:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "", "label 1");
	dw->addLabel(dw->panel,  20, 45, "", "label 2");
	dw->addLabel(dw->panel,  20, 70, "", "label 3");
	dw->addLabel(dw->panel,  456, 20, "", "icon");
	dw->setItem(dw->panel, "icon", LXPI_IMAGE, query_icon);
	dw->addButton(dw->panel, _3button1_xloc, button_sm_yloc, " yes ", confirm);
	dw->addButton(dw->panel, _3button2_xloc, button_sm_yloc, " no ", deny);
	dw->addButton(dw->panel, _3button3_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	/* parameter-querying windows for file commands */
		
	case D_FNEW:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Create New Soundfile:", "label 1");
	dw->addText(dw->panel, 20, 45, "Enter sfname:", "", check_txt);
	dw->addText(dw->panel, 20, 70, "Enter sampling rate:", 
#ifdef NeXT
			"44100",
#else
			"30000",
#endif			
				check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 95,
		LXPI_STRING, "Number of channels:",
		LXPENUM_SELSTRINGS, "1", "2", (char *) NULL,
		LXPENUM_SELXS, 20, 80, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, 60, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "chans");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20,
		LXPI_Y, 150,
		LXPI_STRING, "Sample size:",
		LXPENUM_SELSTRINGS, "short", "float", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "samp size");
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;
	
	case D_FOPEN:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Open Soundfile:", "label 1");
	dw->addText(dw->panel, 20, 45, "Sfname:", "", check_txt);
	dw->addText(dw->panel, 20, 70, "Time to skip (secs.):", "0.00", check_val);
	dw->addText(dw->panel, 20, 95, "Duration to read:", "", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_FSAVETO:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Save Soundfile:", "label 1");
	dw->addText(dw->panel, 20, 45, "New sfname:", v->sfname, check_txt);
#if NeXT_STYLE_HEADER
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 70,
		LXPI_STRING, "Soundfile type:",
		LXPENUM_SELSTRINGS, 
			HYBRID, NATIVE, "Ircam", (char *) NULL,
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "soundfile type");
#endif
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;
	
		/* parameter-querying windows for edit commands */
		
	case D_QMIX:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Mix Buffer Contents:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Amp factor for mix:", "1.00", check_val);
	dw->addText(dw->panel, 20, 70, "Mix how many times?:", "1", check_val);
	dw->addChoice(dw->panel, 20, 95, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QREPLACE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Replace With Buffer Contents:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Amp factor for replace:", "1.00", check_val);
	dw->addText(dw->panel, 20, 70, "Replace how many times?:", "1", check_val);
	dw->addChoice(dw->panel, 20, 95, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QSPLICE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Splice In Buffer Contents:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Amp factor for splice:", "1.00", check_val);
	dw->addText(dw->panel, 20, 70, "Splice in how many times?:", "1", check_val);
	dw->addChoice(dw->panel, 20, 95, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QMULT:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Multiply By Buffer Contents:",
			"label 1");
	dw->addText(dw->panel, 20, 45, "Amp factor for mult:", "0.001", check_val);
	dw->addChoice(dw->panel, 20, 70, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QCFADE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Crossfade Buffer With Soundfile:",
			"label 1");
	dw->addText(dw->panel, 20, 45, "Amp factor for crossfade:", "1.00", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
		/* parameter-querying windows for alter commands, etc */
		
	case D_QAMODE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"The length of the altered region will", 
			"label 1");
	dw->addLabel(dw->panel,  20, 45,
			"be different than the original.",
			"label 2");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 70,
		LXPI_STRING, "Do you wish to:",
		LXPENUM_SELSTRINGS, "splice in new in place of old?", 
			"overwrite file with extra?", 
			"mix extra into file?", (char *) NULL,
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "alter mode");
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;
	
	case D_QPHRASE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Phrase Selected Region:",  "label 1");
	dw->addText(dw->panel, 20, 45, "Amplitude factor:", "1.00", check_val);
	dw->addChoice(dw->panel, 20, 70, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QINSERT:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Insert Space:", "label 1");
	dw->addText(dw->panel, 20, 45, "Amount to insert (secs.):", "0.00", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QTRANS:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Transpose Selected Region:",  "label 1");
	dw->addText(dw->panel, 20, 145, "Interval:", "0.00", check_val);
	dw->addText(dw->panel, 20, 170, "Amp factor:", "1.00", check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 45,
		LXPI_STRING, "Transposition Mode:",
		LXPENUM_SELSTRINGS, "Octave Point P.C.", 
			"Linear Octave", "Frequency Ratio", 
			(char *) NULL,
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "trans mode");
	dw->addChoice(dw->panel, 20, 195, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;
		
	case D_QGRAVY:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_lrght, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Gravy Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Frame size (sec.):", "0.05", check_val);
	dw->addText(dw->panel, 20, 70, "Bevel factor:", "0.5", check_val);
	dw->addText(dw->panel, 20, 195, "Interval:", "0.00", check_val);
	dw->addText(dw->panel, 20, 220, "Length mult:", "1.00", check_val);
	dw->addText(dw->panel, 20, 245, "Amp factor:", "1.00", check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 95,
		LXPI_STRING, "Transposition Mode:",
		LXPENUM_SELSTRINGS, "Octave Point P.C.", 
			"Linear Octave", "Frequency Ratio", 
			(char *) NULL,
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "trans mode");
	dw->addChoice(dw->panel, 20, 270, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_lrg_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_lrg_yloc, "cancel", cancel);
	break;
		
	case D_QMELL:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_lrght, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Elliptical-filter Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Passband Cutoff (cps):", "1000.0", check_val);
	dw->addText(dw->panel, 20, 70, "Stopband Cutoff (cps):", "2000.0", check_val);
	dw->addText(dw->panel, 20, 95, "Bandpass Stopband (cps):", "0.0", check_val);
	dw->addText(dw->panel, 20, 120, "Ripple (db.):", "0.1", check_val);
	dw->addText(dw->panel, 20, 145, "Stopband Attenuation (db.):", "90.0",
			check_val);
	dw->addText(dw->panel, 20, 170, "Amp factor:", "1.00", check_val);
	dw->addChoice(dw->panel, 20, 205, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_lrg_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_lrg_yloc, "cancel", cancel);
	break;
	
	case D_QTONE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Tone-filter Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 70, "Cutoff frequency:", "500.0", check_val);
	dw->addText(dw->panel, 20, 95, "Amp factor:", "1.00", check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 45,
		LXPI_STRING, "Filter mode:",
		LXPENUM_SELSTRINGS, "low pass", "high pass", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "filt mode");
	dw->addChoice(dw->panel, 20, 120, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QRESON:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Reson-filter Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 145, "Center frequency (cps):", "1000.0",
			check_val);
	dw->addText(dw->panel, 20, 170, "Bandwidth (cps):", "100.0", check_val);
	dw->addText(dw->panel, 20, 195, "Amp factor:", "1.00", check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 45,
		LXPI_STRING, "Filter Gain Mode:",
		LXPENUM_SELSTRINGS, "Peak Set To Unity", "Unity RMS Value", 
		"No Rescaling", (char *) NULL, 
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 1,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "gain mode");
	dw->addChoice(dw->panel, 20, 220, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;
		
	case D_QCOMB:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Comb-filter Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 120, "Filter value:", "1000.0",
			check_val);
	dw->addText(dw->panel, 20, 145, "Ring time (secs.):", "0.1", check_val);
	dw->addText(dw->panel, 20, 170, "Amp factor:", "1.00", check_val);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 45,
		LXPI_STRING, "Filter value type:",
		LXPENUM_SELSTRINGS, "Fundamental frequency (cps)",
		"Loop time (seconds)", (char *) NULL, 
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 44, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 44, LXPENUM_LOCTERM,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "filter mode");
	dw->addChoice(dw->panel, 20, 195, "Amplitude mode:", modelist, 2, PROC_NULL);
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;

	case D_SFORMAT:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Change Sample Format:", "label 1");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 45,
		LXPI_STRING, (char *) NULL,
		LXPENUM_SELSTRINGS, "8-bit mulaw", "16-bit short", 
			"floating point", (char *) NULL,
		LXPENUM_SELXS, 20, LXPENUM_LOCTERM,
		LXPENUM_SELYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPENUM_MARKXS, 0, LXPENUM_LOCTERM,
		LXPENUM_MARKYS, 20, 45, 70, LXPENUM_LOCTERM,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "file format");
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
		
	case D_SRATE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Change Sampling Rate:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "New sampling rate:", "", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
		
	case D_SFLEN:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Change Soundfile Length:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "New length (in seconds):", "",
			check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
		
	case D_QFFT:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Fast Fourier Transform of Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 120, "FFT data file:", "", check_txt);
	dw->addChoice(dw->panel, 20, 45, "Frame size (samples):", fftlist, 
		6, PROC_NULL);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 95,
		LXPI_STRING, "Amplitude Display:",
		LXPENUM_SELSTRINGS, "Linear", "Decibel", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "amp mode");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 145,
		LXPI_STRING, "Data File Type:",
		LXPENUM_SELSTRINGS, "No header", "With header", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "file type");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 170,
		LXPI_STRING, "Display data?",
		LXPENUM_SELSTRINGS, "No", "Yes", (char *) NULL,
		LXPENUM_VALUE, 1,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "display mode");
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;

	case D_QLPC:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Linear Predictive Analysis of Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Number of filter poles:", "34", check_val);
	dw->addText(dw->panel, 20, 70, "Frame offset (samples):", "200", check_val);
	dw->addText(dw->panel, 20, 95, "Frame rate (Hz):", "", check_val);
	dw->addText(dw->panel, 20, 120, "LPC data file:", "", check_txt);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 145,
		LXPI_STRING, "Data File Type:",
		LXPENUM_SELSTRINGS, "No header", "With header", (char *) NULL,
		LXPENUM_VALUE, 
#ifdef NeXT
		1,
#else
		0,
#endif
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "file type");
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 170,
		LXPI_STRING, "Display data?",
		LXPENUM_SELSTRINGS, "No", "Yes", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "display mode");
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;

	case D_QPTRACK:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Pitch Track Analysis of Selected Region:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Frame size (samples):", "350", check_val);
	dw->addText(dw->panel, 20, 70, "Frame offset (samples):", "200", check_val);
	dw->addText(dw->panel, 20, 95, "Frame rate (Hz):", "", check_val);
	dw->addText(dw->panel, 20, 120, "High pitch boundry (Hz):", "1000", check_val);
	dw->addText(dw->panel, 20, 145, "Low pitch boundry (Hz):", "100", check_val);
	dw->addText(dw->panel, 20, 170, "Pitch data file:", "", check_txt);
	item = panelitem_create(dw->getPanel(dw->panel), LXPI_CHOICE,
		LXPI_X, 20, LXPI_Y, 195,
		LXPI_STRING, "Display data?",
		LXPENUM_SELSTRINGS, "No", "Yes", (char *) NULL,
		LXPENUM_VALUE, 0,
		LXPI_NULL);
	dw->addChoiceItem(dw->panel, item, "display mode");
	dw->addButton(dw->panel, _2button1_xloc, button_med_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_med_yloc, "cancel", cancel);
	break;

	case D_QRANGE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Set Value Range for Curve:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Minimum value:", "0.00", check_val);
	dw->addText(dw->panel, 20, 70, "Maximum value:", "1.00", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;

	case D_QGRAIN:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Set Horizontal Resolution (grainsize):",
			"label 1");
	dw->addText(dw->panel, 20, 45, "Grainsize (in samps/grain):", "",
		check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QVSCALE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20,
			"Set Vertical Resolution:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Scale [+- max vert amp]: +-", "",
		check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QSTIMES:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Set Screen Times (in seconds):",
			"label 1");
	dw->addText(dw->panel, 20, 45, "Start time:", "", check_val);
	dw->addText(dw->panel, 20, 70, "End time:", "", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;

	case D_QSFDIR:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Set New Soundfile Directory:", 
			"label 1");
	dw->addText(dw->panel, 20, 45, "Directory:", "", check_txt);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;

	case D_SFINFO:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_medht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Soundfile Header Information:", "label 9");
	dw->addLabel(dw->panel,  20, 45, "", "label 1");
	dw->addLabel(dw->panel,  20, 70, "", "label 2");
	dw->addLabel(dw->panel,  20, 95, "", "label 3");
	dw->addLabel(dw->panel,  20, 120, "", "label 4");
	dw->addLabel(dw->panel,  20, 145, "", "label 5");
	dw->addLabel(dw->panel,  20, 170, "", "label 6");
	dw->addLabel(dw->panel,  20, 195, "", "label 7");
	dw->addLabel(dw->panel,  20, 220, "", "label 8");
	dw->addButton(dw->panel, button_xloc, button_med_yloc, "confirm", confirm);
	break;

	case D_QSVSCALE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Set Vertical Display:", "label 1");
	dw->addText(dw->panel, 20, 70, "Maximum:", "", check_val);
	dw->addText(dw->panel, 20, 90, "Minimum:", "", check_val);
	dw->addChoice(dw->panel, 20, 45, "for data channel:", 
		chanlist, 4, set_channel_vals);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;
	
	case D_QSHSCALE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel,  20, 20, "Set Horizontal Display:", "label 1");
	dw->addText(dw->panel, 20, 45, "Start:", "", check_val);
	dw->addText(dw->panel, 20, 70, "End:", "", check_val);
	dw->addButton(dw->panel, _2button1_xloc, button_sm_yloc, "confirm", confirm);
	dw->addButton(dw->panel, _2button2_xloc, button_sm_yloc, "cancel", cancel);
	break;

	case D_COMCLOSE:
	dw = new_dialog_win(root, DFRAME_WIDTH, dframe_smht, x, y, dbw);
	dw->addLabel(dw->panel, 20, 45, 
		"Press \"SAVE\" to go back and save the newest", "label 1");
	dw->addLabel(dw->panel, 20, 70,
		"changes to the soundfile comment, \"discard\" to", "label 2"); 
	dw->addLabel(dw->panel, 20, 95, 
		"discard, or \"cancel\" to leave comment alone.", "label 3");
	dw->addButton(dw->panel, _3button1_xloc, button_sm_yloc, "save", confirm);
	dw->addButton(dw->panel, _3button2_xloc, button_sm_yloc, "discard", deny);
	dw->addButton(dw->panel, _3button3_xloc, button_sm_yloc, "cancel", cancel);
	dw->setDefaultButton(dw->panel, "save");
	dw->alert = 1;	/* set flag for bell */
	break;

	default:
	fprintf(stderr, "new_dialog: invalid index %d\n", d_index);
	return (Dialog_win *) NULL;
	
	}
	return(dlist->addDialog(dlist, dw, d_index));
}

void
dialog_setText(d, index, string)
Dialog_win *d;
int index;
char *string;
{
	char *get_filename();
	char tmpstring[64], tmpstring2[64], filename[38], *newdir;

	switch(index) {
	case D_ALERT:
		d->setItem(d->panel, "label 1", LXPI_STRING, string);
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_ERROR:
		d->setItem(d->panel, "label 1", LXPI_STRING, string);
		sprintf(tmpstring, "Error:  %s.", strerror(errno=errnum));
		d->setItem(d->panel, "label 2", LXPI_STRING, tmpstring);
		errno = 0;
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_QUERY:
		d->setItem(d->panel, "label 1", LXPI_STRING, "");
		d->setItem(d->panel, "label 2", LXPI_STRING, string);
		d->setItem(d->panel, "label 3", LXPI_STRING, "");
		d->setDefaultButton(d->panel, "cancel");
		break;
	case D_QRESCALE:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Do you wish to rescan this file for peak amp?");
		d->setDefaultButton(d->panel, " yes ");
		break;
	case D_CONFINS:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Please confirm this insert operation.");
		d->setDefaultButton(d->panel, " yes ");
		break;
	case D_NOPEN:
		getsfname(string, filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Unable to open soundfile");
		d->setItem(d->panel, "label 2", LXPI_STRING, filename);
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_NHEADER:
		getsfname(string, filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			 "Unable to read header on soundfile");
		d->setItem(d->panel, "label 2", LXPI_STRING, filename);
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_NBMEM:
		getsfname(string, filename);
		sprintf(tmpstring2, "soundfile %s", filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			 "Unable to allocate enough memory for");
		d->setItem(d->panel, "label 2", LXPI_STRING, tmpstring2);
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_NWHEADER:
		getsfname(string, filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			 "Unable to write header to soundfile");
		d->setItem(d->panel, "label 2", LXPI_STRING, filename);
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_NEXTBUF:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"External buffer is not selected or");
		d->setItem(d->panel, "label 2", LXPI_STRING,
			"doesn't match current file format!");
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;;
	case D_SBQUIT:
		getsfname(string, filename);
		sprintf(tmpstring2, "soundfile %s", filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Do you wish to save changes to");
		d->setItem(d->panel, "label 2", LXPI_STRING, tmpstring2);
		d->setItem(d->panel, "label 3", LXPI_STRING, 
			"before exiting?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_FCLOSE:
		getsfname(string, filename);
		sprintf(tmpstring2, "soundfile %s", filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Do you wish to save changes to");
		d->setItem(d->panel, "label 2", LXPI_STRING, tmpstring2);
		d->setItem(d->panel, "label 3", LXPI_STRING, 
			"before closing?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_RONLY:
		getsfname(string, filename);
		sprintf(tmpstring2, "Soundfile %s", filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, tmpstring2);
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"is read-only!");
		d->setDefaultButton(d->panel, " okay ");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_SFEXISTS:
		getsfname(string, filename);
		sprintf(tmpstring2, "Soundfile %s", filename);
		d->setItem(d->panel, "label 1", LXPI_STRING, tmpstring2);
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"already exists.  Replace it?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_FREVERT:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Are you sure you wish to");
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"revert to the saved version?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_SAVWARN:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Saving this file segment back to the");
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"original file will result in the loss");
		d->setItem(d->panel, "label 3", LXPI_STRING, 
			"of the file's full contents.  Continue?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_LENWARN:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Warning:  this operation will destroy any data");
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"that is past the new soundfile end.  Continue?");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_WASMULAW:
		d->setItem(d->panel, "label 1", LXPI_STRING, 
			"Warning: This is a converted mu-law format file.");
		d->setItem(d->panel, "label 2", LXPI_STRING, 
			"Do you wish to save it in its new format?");
		d->setItem(d->panel, "label 3", LXPI_STRING, 
			"If not, cancel and use the \"Sample format\" command.");
		d->setDefaultButton(d->panel, "cancel");
		d->alert = 1;	/* set flag for bell */
		break;
	case D_FOPEN:
		d->setItem(d->panel, "Sfname:", LXPTEXT_MAXDISPLAY, 32);
		d->setItem(d->panel, "Sfname:", LXPTEXT_VALUE, string);
		d->setItem(d->panel, "Sfname:", LXPTEXT_IPOS, strlen(string));
		d->setItem(d->panel, "Time to skip (secs.):", 
			LXPTEXT_VALUE, "0.00");
		d->setItem(d->panel, "Duration to read:", LXPTEXT_VALUE, "");
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_FSAVETO:
		d->setItem(d->panel, "New sfname:", LXPTEXT_MAXDISPLAY, 32);
		d->setItem(d->panel, "New sfname:", LXPTEXT_VALUE, string);
		d->setItem(d->panel, "New sfname:", LXPTEXT_IPOS, strlen(string));
#if NeXT_STYLE_HEADER
		d->setItem(d->panel, "soundfile type", 
			LXPENUM_VALUE, isNative(&v->sfh));
#endif
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_SFORMAT:
		d->setItem(d->panel, "file format", LXPI_STRING, (v->size==1) ? 
			"Convert 8-bit mulaw file to:" : (v->size==2) ? 
			"Convert 16-bit short file to:" : 
			"Convert floating point file to:");
		d->setItem(d->panel, "file format", LXPENUM_VALUE,
			v->size==1 ? 1 : v->size==2 ? 0 : 1);
		break;
	case D_SRATE:
		sprintf(tmpstring, "%d", v->srate);
		d->setItem(d->panel, "New sampling rate:", LXPTEXT_VALUE, tmpstring);
		d->setItem(d->panel, "New sampling rate:", 
			LXPTEXT_IPOS, strlen(tmpstring));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_SFLEN:
		sprintf(tmpstring, "%f", v->sfdur);
		d->setItem(d->panel, "New length (in seconds):", 
			LXPTEXT_VALUE, tmpstring);
		d->setItem(d->panel, "New length (in seconds):", 
			LXPTEXT_IPOS, strlen(tmpstring));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QGRAIN:
		sprintf(tmpstring, "%f", v->grainsize);
		d->setItem(d->panel, "Grainsize (in samps/grain):", 
			LXPTEXT_VALUE, tmpstring);
		d->setItem(d->panel, "Grainsize (in samps/grain):", 
			LXPTEXT_IPOS, strlen(tmpstring));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QVSCALE:
		sprintf(tmpstring, "%f", v->peakamp);
		d->setItem(d->panel, "Scale [+- max vert amp]: +-", 
			LXPTEXT_VALUE, tmpstring);
		d->setItem(d->panel, "Scale [+- max vert amp]: +-",
			LXPTEXT_IPOS, strlen(tmpstring));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QSTIMES:
		d->setItem(d->panel, "Start time:", LXPTEXT_VALUE, "0.000");
		d->setItem(d->panel, "Start time:", LXPTEXT_IPOS, 5);
		sprintf(tmpstring, "%f", v->sfdur);
		d->setItem(d->panel, "End time:", LXPTEXT_VALUE, tmpstring);
		d->setItem(d->panel, "End time:", 
			LXPTEXT_IPOS, strlen(tmpstring));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QSFDIR:
		d->setItem(d->panel, "Directory:", LXPTEXT_VALUE, string);
		d->setItem(d->panel, "Directory:", 
			LXPTEXT_IPOS, strlen(string));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_SFINFO:
		sprintf(tmpstring, "%s%s","Sfdir: ", v->sfdir);
		d->setItem(d->panel, "label 1", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%s","Sfname: ", v->sfname);
		d->setItem(d->panel, "label 2", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%d","Srate: ", v->srate);
		d->setItem(d->panel, "label 3", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%7.2f","Duration: ", v->sfdur);
		d->setItem(d->panel, "label 4", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%.4f","File Size (Mb.): ",
			(v->bufsize+headerSize(&v->sfh))/1000000.);
		d->setItem(d->panel, "label 5", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%d","Nchans: ", v->nchans);
		d->setItem(d->panel, "label 6", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%s %s","Type: ",
#if NeXT_STYLE_HEADER
			isNative(&v->sfh) ? NATIVE :
				isIrcam(&v->sfh) ? "IRCAM" : HYBRID,
#else
			"IRCAM",
#endif
			 v->size==4 ? "floating point" :
			(v->size==2 ? "16-bit short" :
#ifdef SOUNDBLASTER
					"unsigned char"
#else
					"8-bit mu law"
#endif
			));
		d->setItem(d->panel, "label 7", LXPI_STRING, tmpstring);
		sprintf(tmpstring, "%s%9.2f","Peak amp: ", v->peakamp);
		d->setItem(d->panel, "label 8", LXPI_STRING, tmpstring);		
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QFFT:
		get_basename(v->sfname, tmpstring, SUFF);
		strcat(tmpstring, ".fft");
		if((newdir = XGetDefault(dpy, progname, "FFTDirectory"))
				== CNULL) 
			getsfname(tmpstring, tmpstring2); /* use SFDIR */
		else
			sprintf(tmpstring2, "%s/%s", 
				newdir, get_filename(tmpstring, filename));
		d->setItem(d->panel, "FFT data file:", LXPTEXT_VALUE, tmpstring2);
		d->setItem(d->panel, "FFT data file:", LXPTEXT_MAXDISPLAY, 32);
		d->setItem(d->panel, "FFT data file:", 
			LXPTEXT_IPOS, strlen(tmpstring2));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QLPC:
		get_basename(v->sfname, tmpstring, SUFF);
		strcat(tmpstring, ".lpc");
		if((newdir = XGetDefault(dpy, progname, "LPCDirectory"))
				== CNULL) 
			getsfname(tmpstring, tmpstring2); /* use SFDIR */
		else
			sprintf(tmpstring2, "%s/%s", 
				newdir, get_filename(tmpstring, filename));
		d->setItem(d->panel, "LPC data file:", LXPTEXT_VALUE, tmpstring2);
		d->setItem(d->panel, "LPC data file:", LXPTEXT_MAXDISPLAY, 32);
		d->setItem(d->panel, "LPC data file:", 
			LXPTEXT_IPOS, strlen(tmpstring2));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QPTRACK:
		get_basename(v->sfname, tmpstring, SUFF);
		strcat(tmpstring, ".pt");
		if((newdir = XGetDefault(dpy, progname, "PTrackDirectory"))
				== CNULL) 
			getsfname(tmpstring, tmpstring2); /* use SFDIR */
		else
			sprintf(tmpstring2, "%s/%s", 
				newdir, get_filename(tmpstring, filename));
		d->setItem(d->panel, "Pitch data file:", LXPTEXT_VALUE, tmpstring2);
		d->setItem(d->panel, "Pitch data file:", LXPTEXT_MAXDISPLAY, 32);
		d->setItem(d->panel, "Pitch data file:", 
			LXPTEXT_IPOS, strlen(tmpstring2));
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QSVSCALE:
		/* this is a test of a new system for setting vals */
		if(dialog->Override[0].val) {
			sprintf(tmpstring, "%f", dialog->text_vals[0]);
			d->setItem(d->panel, "Maximum:", LXPTEXT_VALUE, 
				tmpstring);
			d->setItem(d->panel, "Maximum:", LXPTEXT_IPOS, 
				strlen(tmpstring));
			dialog->Override[0].val = False;
		}
		if(dialog->Override[1].val) {
			sprintf(tmpstring, "%f", dialog->text_vals[1]);
			d->setItem(d->panel, "Minimum:", LXPTEXT_VALUE, 
				tmpstring);
			d->setItem(d->panel, "Minimum:", LXPTEXT_IPOS, 
				strlen(tmpstring));
			dialog->Override[1].val = False;
		}
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_QSHSCALE:
		/* this is a test of a new system for setting vals */
		if(dialog->Override[0].val) {
			sprintf(tmpstring, "%0.1f", dialog->text_vals[0]);
			d->setItem(d->panel, "Start:", LXPTEXT_VALUE, 
				tmpstring);
			d->setItem(d->panel, "Start:", LXPTEXT_IPOS, 
				strlen(tmpstring));
			dialog->Override[0].val = False;
		}
		if(dialog->Override[1].val) {
			sprintf(tmpstring, "%0.1f", dialog->text_vals[1]);
			d->setItem(d->panel, "End:", LXPTEXT_VALUE, 
				tmpstring);
			d->setItem(d->panel, "End:", LXPTEXT_IPOS, 
				strlen(tmpstring));
			dialog->Override[1].val = False;
		}
		d->setDefaultButton(d->panel, "confirm");
		break;
	case D_FNEW:
	case D_QMIX:
	case D_QREPLACE:
	case D_QSPLICE:
	case D_QMULT:
	case D_QCFADE:
	case D_QPHRASE:
	case D_QINSERT:
	case D_QTRANS:
	case D_QGRAVY:
	case D_QMELL:
	case D_QTONE:
	case D_QRESON:
	case D_QCOMB:
		d->setDefaultButton(d->panel, "confirm");
		break;	
	default:
		break;
	}
}

void
confirm(p, pi)
Panel *p;
Panel_item *pi;
{
	panel_unblock(p, YES);
}

void
deny(p, pi)
Panel *p;
Panel_item *pi;
{
	panel_unblock(p, NO);
}

void
cancel(p, pi)
Panel *p;
Panel_item *pi;
{
	panel_unblock(p, CANCEL);
}

int
check_txt(p, pi, string)	/* checks for proper text entry */
Panel *p;
Panel_item *pi;
char *string;
{
	char c = string[0];
	/* <return> key calls one of the button procs */
	if(c == '\n' || c == '\r') {
		if(default_button_proc) (*default_button_proc)(p, pi);
		return False;
	}		
	else return True;
}

int
check_val(p, pi, string)	/* checks for proper numerical entry */
Panel *p;
Panel_item *pi;
char *string;
{
	char c = string[0];
	char c2 = string[1];
	/* <return> key calls one of the button procs */
	if(c == '\n' || c == '\r') {
		if(default_button_proc) (*default_button_proc)(p, pi);
		return False;
	}		
	if(isdigit(c)){
		return True;	/* regular digit typed */
	}
	if(c == '-' || c == '+') {
		return True;	/* or optional sign    */
	}
	if(c == '.') {
		return True;	/* or decimal place.    */
	}
	if(iscntrl(c) && c2 == 0){	/* modifier  key */
		return True;
	}
	XBell(dpy, 0);	/* default is error */
	return False;
}

int
get_win_coords(win, x, y)	/* retrieves coords of main win vs. root */
Window win;
int *x, *y;
{
	static Window root, parent, *children;
	static int lastx= -1000, lasty= -1000;
	unsigned int nchildren, w, h, bw, d;
	if(XQueryTree(dpy, win, &root, &parent, &children, &nchildren) < 0)
		mv_die(errno, "get_win_coords:  window does not exist.");
	if(parent != root) {	/* if win is not child of root */
		win = parent;
		if(XQueryTree(dpy, win, 
				&root, &parent, &children, &nchildren) < 0)
			mv_die(errno, "get_win_coords:  window does not exist.");
		win = parent;
	}
	XGetGeometry(dpy, win, &root, x, y, &w, &h, &bw, &d);
	XFree((char *) children);
	if(*x == lastx && *y == lasty) return 0;
	else {
		lastx = *x;
		lasty = *y;
		return 1;
	}
}

void
dialog_show(dw)		/* will be member of Dialog_win object */
Dialog_win *dw;
{
	if(dw->alert)
		XBell(dw->panel->dpy, 0);
	panel_block((dw->panel)->panel, &(dw->ret_code));
}

int
dialog_code(dw)	/* will be member of Dialog_win object */
Dialog_win *dw;
{
	return dw->ret_code;
}

extern Mv_panel *new_panel();

Dialog_win *
new_dialog_win(parent, width, height, xpos, ypos, bw)
Window parent;
unsigned width, height, bw;
int xpos, ypos;
{
	Dialog_win *dw;
	
	dw = (Dialog_win *) mv_alloc(sizeof(Dialog_win)); 
	dw->ret_code = dw->alert = 0;
	dw->panel = new_panel(parent, width, height, xpos, ypos, bw);
	dw->show = dialog_show;
	dw->setText = dialog_setText;
	dw->code = dialog_code;
	dw->addLabel = pan_addLabel;		/* inherited?? */
	dw->addText = pan_addText;		/* inherited?? */
	dw->addButton = pan_addButton;		/* inherited?? */
	dw->setDefaultButton = pan_setDefaultButton;
	dw->addChoice = pan_addChoice;		/* inherited?? */
	dw->addChoiceItem = pan_addChoiceItem;	/* inherited?? */
	dw->addItem = pan_addItem;		/* inherited?? */
	dw->getPanel = pan_getPanel;		/* inherited?? */
	dw->moveFrame = pan_moveFrame;		/* inherited?? */
	dw->setItem = pan_setItem;		/* inherited?? */
	dw->getItem = pan_getItem;		/* inherited?? */
	dw->getItemN = pan_getItemN;		/* inherited?? */
	dw->nItems = pan_nItems;
	dw->nLabels = pan_nLabels;
	dw->nTexts = pan_nTexts;
	dw->nButtons = pan_nButtons;
	dw->nChoices = pan_nChoices;
	return dw;
}

int
dlist_winIndex(dl, indx) /* returns index for dialog window type for setup */
Dialog *dl;
int indx;
{
	int code;
	switch(indx) {
	case D_QRESCALE:
	case D_CONFINS:
		code = D_1L2B;
		break;
	case D_NOPEN:
	case D_NHEADER:
	case D_NBMEM:
	case D_NEXTBUF:
	case D_NWHEADER:
	case D_RONLY:
		code = D_2L1B;
		break;
	case D_SFEXISTS:
	case D_FREVERT:
	case D_LENWARN:
		code = D_2L2B;
		break;
	case D_SAVWARN:
	case D_WASMULAW:
		code = D_3L2B;
		break;
	case D_SBQUIT:
	case D_FCLOSE:
	case D_QUERY:
		code = D_3L3B;
		break;
	default:
		code = indx;
	}
	return code;
}

/* sets up items in dialog-panel and display it */

int
dlist_Call(dl, d_index, string) /* will be member of Dialog obj. */
Dialog *dl;
int d_index;
char *string;
{
	Dialog_win *dw;
	int x, y;
	
	XSync(dpy, 0);
	if(dl->currentwin) {
		panel_unblock((dl->currentwin->panel)->panel, CANCEL);
		dl->currentwin = 0;
	}
	if((dw = dl->getDialog(dl, dl->winIndex(dl, d_index))) 
			== (Dialog_win *) NULL)
		dw = dl->newDialog(dl, dl->winIndex(dl, d_index));
	dw->setText(dw, d_index, string);
	if(get_win_coords(mixwin, &x, &y))
		dw->moveFrame(dw->panel, x, y);
	dl->currentwin = dw;
	dw->show(dw);				/* display it */
	dl->getValues(dl, dl->winIndex(dl, d_index));
	dl->currentwin = 0;
	return(dw->code(dw));		/* return code */
}


Dialog_win *
dlist_addDialog(dl, dw, loc)	/* will be member of Dialog object */
Dialog *dl;
Dialog_win *dw;
int loc;
{
	if(loc >= dl->maxwins) dl->extendList(dl, 5);
	dl->list[loc] = dw;
	dl->nwins++;
	return dw;
}

void
dlist_extendList(dl, nlocs)
Dialog *dl;
int nlocs;
{
	Dialog_win **ptr;
	int new_size = dl->maxwins + nlocs;
	DBENT(extend_list);
	ptr = dl->list;
	ptr = (Dialog_win **) realloc((char *) ptr, (unsigned) (sizeof(POINTER) * new_size));
	if(ptr == (Dialog_win **) NULL)
		mv_die(errno, "extend_list: unable to allocate memory.");
	dl->list = ptr;
	cfree((char *) dl->list);
	dl->maxwins += nlocs;
	DBEXT(extend_list);
}

Dialog_win *
dlist_getDialog(dl, indx)
Dialog *dl;
int indx;
{
	if(indx < dl->maxwins) return dl->list[indx];
	else return (Dialog_win *) NULL;
}

void
dlist_getValues(dl, d_index)  /* member of Dialog obj.  */
Dialog *dl;
int d_index;
{
	Panel_item *item;
	int i, skip, ntexts, nlabels, nchoices;
	Dialog_win *dw;
	if((dw = dl->getDialog(dl, d_index)) == (Dialog_win *) NULL)
		mv_die(errno, "getItem_values: null dialog window");
	nlabels = dw->nLabels(dw->panel);
	ntexts = dw->nTexts(dw->panel);
	skip = nlabels;		 /* skip past labels */
	for(i=0; i<ntexts; i++) {
		item = dw->getItemN(dw->panel, i + skip); 
		dl->text_strings[i] = 
			(char *) panelitem_get(dw->getPanel(dw->panel), item,
						LXPTEXT_VALUE);
		if(strlen(dl->text_strings[i]))
			dl->text_vals[i] = atof(dl->text_strings[i]);
		else dl->text_vals[i] = 0.0;
	}
	nchoices = dw->nChoices(dw->panel);
	skip = nlabels + ntexts;	/* skip past labels and texts */
	for(i=0; i < nchoices; i++) {
		item = dw->getItemN(dw->panel, i + skip);
		dl->choice_vals[i] = 
			*((int *) panelitem_get(dw->getPanel(dw->panel), item, 
						LXPENUM_VALUE));
	}
}

char *
dlist_getText(d, index)
Dialog *d;
int index;
{
	if(index >= d->maxtexts)
		return (char *) NULL;
	return d->text_strings[index];
}

void
dlist_setValue(d, index, value)
Dialog *d;
int index;
double value;
{
	if(index >= d->maxtexts)
		return;
	d->text_vals[index] = value;
	d->Override[index].val = True;
}

double
dlist_getValue(d, index)
Dialog *d;
int index;
{
	if(index >= d->maxtexts)
		return (double) 0;
	return d->text_vals[index];
}

void
dlist_setChoice(d, index, choice)
Dialog *d;
int index, choice;
{
	if(index >= d->maxchoices)
		return;
	d->choice_vals[index] = choice;
}

int
dlist_getChoice(d, index)
Dialog *d;
int index;
{
	if(index >= d->maxchoices)
		return (int) NULL;
	return d->choice_vals[index];
}

Dialog *
new_dialog_list(Dl, parent)
Dialog *Dl;
Window parent;
{
	Dl = (Dialog *) mv_alloc(sizeof(Dialog));
	Dl->nwins = 0;
	Dl->maxwins = 40;
	Dl->maxtexts = MAXTEXTS;
	Dl->maxchoices = MAXCHOICES;
	Dl->list = (Dialog_win **) mv_alloc(Dl->maxwins*sizeof(POINTER));
	Dl->text_strings = (char **) mv_alloc(MAXTEXTS*sizeof(POINTER));
	Dl->text_vals = (double *) mv_alloc(MAXTEXTS*sizeof(double));
	Dl->choice_vals = (int *) mv_alloc(MAXCHOICES*sizeof(int));
	Dl->Override = (struct override *) mv_alloc(MAXTEXTS*sizeof(struct override));
/* functions */
	Dl->getValues = dlist_getValues;
	Dl->winIndex = dlist_winIndex;
	Dl->getText = dlist_getText;
	Dl->setValue = dlist_setValue;
	Dl->setChoice = dlist_setChoice;
	Dl->getValue = dlist_getValue;
	Dl->getChoice = dlist_getChoice;
	Dl->extendList = dlist_extendList;
	Dl->getDialog = dlist_getDialog;
	Dl->addDialog = dlist_addDialog;
	Dl->newDialog = dlist_newDialog;
	Dl->call = dlist_Call;
	return Dl;
}

char *
get_basename(name, newname, suff)	/* returns filename minus suffix */
char *name, *newname, *suff;
{
	int index = strlen(name) - strlen(suff);
	if(!is_suffix(name, suff)) index = strlen(name);
	strncpy(newname, name, index);
	newname[index] = '\0';
	return newname;
}

char *
get_filename(name, newname)	/* returns filename minus path */
char *name, *newname;
{
	char *lastslash = rindex(name, '/');
	if(lastslash != NULL) {
		strcpy(newname, lastslash+1);
	}
	else {
		strcpy(newname, name);
	}
	return newname;
}
