
#import <appkit/appkit.h>
#import "EasyBTXProtocol.h"


#define MAX_STATE_LEN 32		/* maximal length of a state string */
#define SYNTAX_ERROR  2


@protocol stopProtocol
- stopInState:(const char*)state;	/* callback method */
@end


@interface StateMachine:Object <btxClientMethods,NXSenderIsInvalid>
{
    id		hash;			/* HashTable (state -> rules) */
    const char	*data;			/* ASCII data (24 rows x 40 cols) */
    char	state[MAX_STATE_LEN];	/* current state */
    NXStream	*inputStream;		/* input stream */
    NXStream	*outputStream;		/* output stream */
    char	*inputVariable[10];	/* input variables \0..\9 */
    id		server;			/* EasyBTX server */
    id		stopReceiver;		/* receiver of stopInState: method */
}


- (const char*) data;
- (const char*) stateString;
- setStateString:(const char*)theState;
- (NXStream*) inputStream;
- setInputStream:(NXStream*)stream;
- (NXStream*) outputStream;
- setOutputStream:(NXStream*)stream;
- (const char*) inputVariableAt:(int)i;
- setInputVariable:(const char*)str width:(int)width at:(int)i;

- openRules:(const char*)filename;

- (BOOL) readInputVariableAt:(int)i width:(int)width;
- outputString:(const char *)str length:(int)length;
- outputRow:(int)row col:(int)col width:(int)width lines:(int)lines;
- (int) ruleMatchForRow:(int)row col:(int)col;
- (int) executeRule;

- server;
- stopReceiver;
- setStopReceiver:(id <stopProtocol>)anObject;
- connect;
- (int) openDialog:sender;
- closeDialog;


@end
