
#import "MyText.h"

@implementation MyText

- initFrame:(const NXRect *)frameRect
	text:(const char *)theText
	alignment:(int)mode
{
    [super initFrame:frameRect text:theText alignment:mode];

    [self setOpaque:YES];

    [self setCharWrap:YES];
    [self setMonoFont:YES];
    [self setFont:[Font userFixedPitchFontOfSize:12 matrix:NX_FLIPPEDMATRIX]];
    [self setEditable:NO];
    [self setSelectable:YES];
    [self setFontPanelEnabled:NO];
    [self setBackgroundGray:NX_WHITE];
    [self setTextGray:NX_BLACK];
    [self setAutodisplay:YES];

    return self;
}


- copy:sender
{
    NXSelPt start, end;
    int row, col, len;
    char str[80], *s;
    id pb;
    const char *types[] = {NXAsciiPboardType};
    
    [self getSel:&start :&end];
    row=start.cp/41;
    col=start.cp%41;
    if (col==40) col--;
    
    len=end.cp-start.cp;
    if (col+len>40)
	len=40-col;

    sprintf(str,"expect(%d,%d,\"",row+1,col+1);
    s=str+strlen(str);
    len=[self getSubstring:s start:start.cp length:len];
    sprintf(s+len,"\")");
    
    pb=[Pasteboard new];
    [pb declareTypes:types num:1 owner:nil];
    [pb writeType:NXAsciiPboardType  data:str length:strlen(str)];
    
    return self;
}


- setASCII:(const char*)buffer
{
    static char str[41*24];
    int i;
    
    for (i=0; i<24; i++) {
	strncpy(str+41*i,buffer+40*i,40);
	str[41*i+40]='\n';
    }
    str[41*23+40]=0;
    
    [self setText:str];
    return self;
}


@end
