#
# Workspace Manager common makefile
#


all::

SUPPORTFILES = IB.nproj Makefile makefile $(NAME).iconheader \
	Makefile.preamble Makefile.postamble *.project SGS_ENV

SRCFILES = $(CLASSES) \
	$(MFILES) $(CFILES) $(HFILES) $(PSWFILES) $(PSWMFILES) \
	$(GLOBAL_RESOURCES) \
	$(OTHERSRCS) $(OTHERLINKED) $(OTHER_SOURCEFILES)

EARLY_OFILES = $(PSWFILES:.psw=.o) $(PSWMFILES:.pswm=.o) 

INITIAL_TARGETS = $(OFILE_DIR) $(EARLY_OFILES) $(PRECOMPS) $(OTHER_INITIAL_TARGETS)

OFILES = $(CLASSES:.m=.o) $(MFILES:.m=.o) $(CFILES:.c=.o) \
	$(EARLY_OFILES) $(SUBPROJECTS:.subproj=.o) $(OTHERLINKEDOFILES)

MAKEFILES = Makefile 

PRODUCT_DEPENDS = $(OFILES) $(OTHER_OFILES) $(ICONHEADER) \
	$(APPICON) $(DOCICONS) $(MAKEFILES) \
	$(OTHER_PRODUCT_DEPENDS)

GARBAGE = $(PSWFILES:.psw=.c) $(PSWMFILES:.pswm=.m) \
	$(PSWFILES:.psw=.h) $(PSWMFILES:.pswm=.m) \
	$(NAME) $(NAME).app $(NAME).debug $(NAME).profile $(NAME).bundle \
	obj debug_obj profile_obj res debug_res profile_res \
	Makefile.dependencies $(OTHER_GARBAGE) gmon.out *~ \
	$(PRECOMPS) $(OTHER_INITIAL_TARGETS)

# Default name for file to use as "reference time of last build"
CHANGES_FILE = $(PRODUCT_ROOT)/.lastBuildTime

# Defaults for who to chown executables to when installing
INSTALL_AS_USER = root
INSTALL_AS_GROUP = wheel

# Defaults for options to $(STRIP)
RELOCATABLE_STRIP_OPTS = -x -u
DYLD_APP_STRIP_OPTS = -A -n
APP_STRIP_OPTS =   # Set this to $(DYLD_APP_STRIP_OPTS) when doing dynaloading yourself

# Various commands:
SHELL  = /bin/sh
FASTCP = /usr/lib/fastcp
CHANGES = /usr/lib/changes
CHOWN  = /etc/chown
CHMOD  = /bin/chmod
TAR    = /bin/tar
STRIP  = /bin/strip
RM     = /bin/rm
ECHO   = /bin/echo
MKDIRS = /bin/mkdirs
TOUCH  = /usr/bin/touch
AWK    = /bin/awk

ADAPTOR_SEARCH_PATH = $(HOME)/Library/Adaptors /LocalLibrary/Adaptors /NextLibrary/Adaptors

VPATH = $(OFILE_DIR):$(LANGUAGE).lproj:$(PRODUCT_ROOT)

.SUFFIXES: .h .m .c .psw .pswm .bproj .subproj .copy .installsrc .writable .clean .o .bundle .depend .lproj

.bproj.copy:
	@(cd $*.bproj; $(MAKE) copy "NAME=$*" "DEST=$(DEST)/$*.bproj")
.subproj.copy:
	@(cd $*.subproj; $(MAKE) copy "NAME=$*" "DEST=$(DEST)/$*.subproj")

.bproj.clean:
	(cd $*.bproj; $(MAKE) clean "NAME=$*" "DEST=$(DEST)/$*.bproj")
.subproj.clean:
	(cd $*.subproj; $(MAKE) clean "NAME=$*" "DEST=$(DEST)/$*.subproj")

.bproj.depend:
	(cd $*.bproj; $(MAKE) depend "NAME=$*")
.subproj.depend:
	(cd $*.subproj; $(MAKE) depend "NAME=$*")

# Compilation rules:
.c.o:
	$(CC) $(CFLAGS) -c $*.c -o $(OFILE_DIR)/$*.o
.m.o:
	$(CC) $(CFLAGS) $(OBJCFLAGS) -c $*.m -o $(OFILE_DIR)/$*.o
.h.p:
	$(CC) -precomp $(CFLAGS) $*.h -o $*.p

# pswrap-related rules:
.psw.h:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.c $*.psw
.psw.c:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.c $*.psw
.psw.o:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.c $*.psw
	$(CC) $(CFLAGS) -c $*.c -o $(OFILE_DIR)/$*.o
.pswm.h:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.m $*.pswm
.pswm.m:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.m $*.pswm
.pswm.o:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.m $*.pswm
	$(CC) $(CFLAGS) $(OBJCFLAGS) -c $*.m -o $(OFILE_DIR)/$*.o


SRCROOT DEST:
	@if [ -n "${$@}" ]; then exit 0; \
	else $(ECHO) Must define $@; exit 1; fi

$(DEST)::
	-$(RM) -rf $(DEST)
	@$(MKDIRS) $(DEST)

$(NAME).copy:: DEST $(DEST)
	@if [ "$(PROJECTVERSION)" -lt "1" -o "$(PROJECTVERSION)" = "1.0" ] ; then \
	    if [ "$(SRCFILES) $(CLASSES:.m=.h)" != "" ] ; then \
	       $(ECHO) "$(TAR) cf - $(SRCFILES) $(CLASSES:.m=.h) | (cd $(DEST); $(TAR) xf -)" ; \
	       $(TAR) cf - $(SRCFILES) $(CLASSES:.m=.h) | (cd $(DEST); $(TAR) xf -) ; \
	     fi ; \
	else \
	    if [ "$(SRCFILES)" != "" ] ; then \
	       $(ECHO) "$(TAR) cf - $(SRCFILES) | (cd $(DEST); $(TAR) xf -)" ; \
	       $(TAR) cf - $(SRCFILES) | (cd $(DEST); $(TAR) xf -) ; \
	    fi ; \
	fi
	@supportfiles=""; \
	$(MKDIRS) $(DEST)/$(LANGUAGE).lproj
	if [ "$(LOCAL_RESOURCES)" != "" ] ; then \
	   (cd $(LANGUAGE).lproj; $(TAR) cf - $(LOCAL_RESOURCES)) | (cd $(DEST)/$(LANGUAGE).lproj; $(TAR) xf -) ; \
	fi
	for i in $(SUPPORTFILES) $(APPICON) $(DOCICONS) none ; do \
	    if [ -r $$i -a ! -r $(DEST)/$$i ] ; then \
		supportfiles="$$supportfiles $$i" ; \
	    fi ; \
	done ; \
	if [ "$$supportfiles" != "" ] ; then \
	   $(ECHO) "$(TAR) cf - $$supportfiles | (cd $(DEST); $(TAR) xf -)" ; \
	   $(TAR) cf - $$supportfiles | (cd $(DEST); $(TAR) xf -) ; \
	fi

$(NAME).clean::
	@if [ ! -w . ] ; then $(ECHO) '***' project write-protected; exit 1 ; fi
	$(RM) -rf $(GARBAGE)


# The following rule actually insures that resources for this particular level in the project hierarchy get copied over to the appropriate place in the PRODUCT_ROOT.  Note that we depend on VPATH including $(LANGUAGE).lproj so that the LOCAL_RESOURCES are found correctly.  FASTCP is used to minimize the copying of files, since most resources are likely to be up to date most of the time.

resources: $(LOCAL_RESOURCES) $(GLOBAL_RESOURCES) $(OTHER_RESOURCES)
	@($(MKDIRS) $(PRODUCT_ROOT)/$(LANGUAGE).lproj ; \
	if [ "$(LOCAL_RESOURCES)" != "" ] ; then \
	   $(FASTCP) $(LOCAL_RESOURCES) $(PRODUCT_ROOT)/$(LANGUAGE).lproj ; \
	fi ; \
	if [ "$(GLOBAL_RESOURCES)" != "" ] ; then \
	   $(FASTCP) $(GLOBAL_RESOURCES) $(PRODUCT_ROOT) ; \
	fi )

# The following rule does the recursion into any subprojects or bundles of this (sub)project and does a 'make project' for each one in its respective directories.  This insures that we do not rely on the directory timestamp or "hacK" file to know whether or not something has changed.  

subcomponents::
	@(targets=`$(CHANGES) $(CHANGES_FILE) $(SUBPROJECTS)` ; \
	for sub in $$targets none ; do \
	   if [ $$sub = "none" ] ; then break; fi ;\
	   cd $$sub; $(ECHO) Making $$sub ; \
	   $(MAKE) project "NAME = $$sub" "PRODUCT_ROOT = ../$(PRODUCT_ROOT)" "OFILE_DIR = ../$(OFILE_DIR)" "CFLAGS = $(CFLAGS)" ; \
	   cd .. ; \
	done ; \
	targets=`$(CHANGES) $(CHANGES_FILE) $(BUNDLES)` ; \
	for bun in $$targets none ; do \
	   if [ $$bun = "none" ] ; then break; fi ; \
	   cd $$bun; $(ECHO) Making $$bun ; \
	   $(MAKE) project "NAME = $$bun" "BUNDLE_DIR = ../$(PRODUCT_ROOT)/$$bun" "OFILE_DIR = $(OFILE_DIR)" "CFLAGS = $(CFLAGS)" ; \
	   cd .. ; \
	done ; )

# Build a set of dependencies for current level into Makefile.dependencies 
   
Makefile.dependencies:: $(CLASSES) $(MFILES) $(CFILES)
	$(RM) -f Makefile.dependencies
	$(CC) -MM $(CFLAGS) $(CLASSES) $(MFILES) $(CFILES) | \
	    $(AWK) '{ if ($$1 != prev) { if (rec != "") print rec; \
		rec = $$0; prev = $$1; } \
		else { if (length(rec $$2) > 78) { print rec; rec = $$0; } \
		else rec = rec " " $$2 } } \
		END { print rec }' > Makefile.dependencies

copy:: $(NAME).copy $(BUNDLES:.bproj=.copy) $(SUBPROJECTS:.subproj=.copy)

writable::
	@chmod -R +w *

protected::
	@chmod -R a-w *

installsrc:: SRCROOT
	@($(MAKE) copy "DEST=$(SRCROOT)")

clean:: $(NAME).clean  $(BUNDLES:.bproj=.clean) $(SUBPROJECTS:.subproj=.clean)

$(OFILE_DIR):
	@$(MKDIRS) $(OFILE_DIR)


