/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <appkit/Application.h>
#import <objc/List.h>
#import "ViewController.h"
#import "CellScrollView.h"
#import "GenericCell.h"
#import "GenericObject.h"
#import "IconView.h"
#import "DragView.h"

@implementation ViewController

static id theViewController;

+ theViewController
{
  return theViewController;
}

- gotItMan:sender
{
  [self displayIconForCurrentSelection];
  return self;
}

- awakeFromNib
{
  [self switchViewToNumber:1];
  return self;
}

- init
{
  theViewController = self;
  [NXApp loadNibSection:"ViewController.nib" owner:self withNames:NO];
  return self;
}

- setFocusLock:(BOOL) val
{
  doFocusLock = val;
  return self;
}

- (BOOL) getFocusLock
{
  return doFocusLock;
}

- initView: (int) viewNum list: aList class: (Class) aClass name: (char *) aName
{

  switch (viewNum)
    {
      case(1):
	{
	  list1 = aList;
	  class1 = aClass;
	  [scrollView1 initCellMatrix];
	  [scrollView1 setCellList:list1];
	  [name1 setStringValue: aName];
	  break;
	}
      case(2):
	{
	  list2 = aList;
	  class2 = aClass;
	  [scrollView2 initCellMatrix];
	  [scrollView2 setCellList:list2];
	  [name2 setStringValue: aName];
	  break;
	}
      case(3):
	{
	  list3 = aList;
	  class3 = aClass;
	  [scrollView3 initCellMatrix];
	  [scrollView3 setCellList:list3];
	  [name3 setStringValue: aName];
	  break;
	}
      default:
        {
	  list1 = aList;
	  class1 = aClass;
	  [scrollView1 initCellMatrix];
	  [scrollView1 setCellList:list1];
	  [name1 setStringValue: aName];
        }
    }
  
  return self;
}

- setMultiView:aView
{
  multiView = aView;
  return self;
}

- setDragView:aView
{
  theDragView = aView;
  return self;
}

- getDragView
{
  return theDragView;
}

- switchView:sender
/* Action method:  Connect this to a each PopUpList cell */
{
  [self switchViewToNumber: [ [sender selectedCell] tag]];
  return self;
}

- switchViewToNumber:(int) aTag
{
  id newContentView = nil;
  NXRect boxRect, viewRect;
  
  switch (aTag)
    {
    case 1:
      {
	newContentView = [view1 contentView];
        currView = view1;
        currScrollView = scrollView1;
        currList = list1;
        currClass = class1;
	break;
      }
    case 2:
      {
	newContentView = [view2 contentView];
        currView = view2;
        currScrollView = scrollView2;
        currList = list2;
        currClass = class2;
	break;
      }
    case 3:
      {
	newContentView = [view3 contentView];
        currView = view3;
        currScrollView = scrollView3;
        currList = list3;
        currClass = class3;
	break;
      }
    default:
      {
	newContentView = [view1 contentView];
        currView = view1;
        currScrollView = scrollView1;
        currList = list1;
        currClass = class1;
	break;
      }
    }
  
  [multiView getFrame:&boxRect];
  [currView getFrame:&viewRect];
  [multiView setContentView:currView];
  
  NX_X(&viewRect)= 
    (NX_WIDTH(&boxRect)-NX_WIDTH(&viewRect)) / 2.0;
  NX_Y(&viewRect) = 
    (NX_HEIGHT(&boxRect)-NX_HEIGHT(&viewRect))/ 2.0;
  
  [currView setFrame:&viewRect];/* center the view */
  [currScrollView updateList];
  [multiView display];
  [theDragView blank];
  return self;
}

- makeCopy:sender
{
  id anObject;
  char *ptr;
  char newName[256];

  anObject = [[self currentObject] copy];
  ptr = [anObject getName];
  if (ptr)
    {
      sprintf(newName, "Copy Of %s", ptr);
      [anObject setName:newName];
    }
  
  [anObject edit];
  [currList addObject:anObject];
  [currScrollView objectsJustAdded];
  [currScrollView updateList];
  [self closeInspector];
  return self;
}

- takeNameFrom:sender
{
  [self addObjectWithName:
   (char *) [sender stringValue]];
  return self;
}

- addObjectWithName:(char *) aName
/* The user can connect a control that
 * has a stringValue in it to this method
 */
{
  id anObject;

  if (! aName)
    {
      return self;
    }

  anObject = [[currClass alloc] init];
  [anObject setName:aName];
  [anObject edit];
  [currList addObject:anObject];
  [currScrollView objectsJustAdded];
  [currScrollView updateList];
  return self;
}

- editSelections:sender
{
  [currScrollView editSelections];
  [self closeInspector];
  return self;
}

- deleteSelections:sender
/*
 * Delete the objects corresponding to the selected 
 * items in currView
 */
{
  [currScrollView deleteSelections];
  [self displayInspector:self];
  [self closeInspector];
  return self;
}

- currentObject
{
  return [currScrollView currentlySelectedObject];
}

- reportCurrentSelection:sender
{
  [currScrollView reportCurrentSelection];
  return self;
}

- displayIconForCurrentSelection
{
  [theDragView showImage:[currScrollView getCurrentImage]];
  return self;
}

- displayInspector:sender
{

  if ([currScrollView haveSelection])
    {
      [theIconView showImage:[currScrollView getCurrentImage]];
      [theLabel setStringValue:[[self currentObject] getName]];
      [inspector setTitle:[[self currentObject] getName]];
      [inspector makeKeyAndOrderFront:self];
    }

  return self;
}

- closeInspector
{
  if (inspector)
    {
      [inspector performClose:self];
    }
  return self;
}

@end
