/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <objc/Object.h>

@interface ViewController:Object
{
    id view1;    // Connected in nib
    id view2;
    id view3;

    id scrollView1;    // Connected in nib
    id scrollView2;
    id scrollView3;

    id list1;    // User allocs and we manage
    id list2;
    id list3;

    id name1;    // Connected in nib
    id name2;
    id name3;

    Class class1;   // User specifies and we manage
    Class class2;
    Class class3;

    id currList;
    id currView;
    id currClass;
    id currScrollView;
    id multiView;  // User provides us with this
    
    id theIconView;
    id theDragView;
    id theLabel;
    id inspector;
    id nameAsker;
    BOOL doFocusLock;

    id editButton;
    id deleteButton;
    id copyButton;
}

+ theViewController;

- gotItMan:sender;

- awakeFromNib;

- init;

- setFocusLock:(BOOL) val;

- (BOOL) getFocusLock;

- initView: (int) viewNum list: aList class: (Class) aClass name: (char *) aName;

- setMultiView:aView;

- setDragView:aView;

- getDragView;

- switchView:sender;

- switchViewToNumber:(int) aTag;

- makeCopy:sender;

- takeNameFrom:sender;

- addObjectWithName:(char *) aName;

- editSelections:sender;

- deleteSelections:sender;

- currentObject;

- reportCurrentSelection:sender;

- displayIconForCurrentSelection;

- displayInspector:sender;

- closeInspector;

@end


