/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <stdlib.h>
#import <string.h>
#import <appkit/Application.h>
#import <appkit/Control.h>
#import <appkit/PopUpList.h>
#import "UGMethodDef.h"
#import "UGDef.h"

@implementation UGMethodDef
#define MAX_STR 512
static char TempString[MAX_STR];

+ initialize
 /* Set the version. This can be used in a later version to distinguish older
  * formats when unarchiving documents. 
  */
{
  [UGMethodDef setVersion:4];
  return self;
}

- awakeFromNib
{
  theIOSwitchPop = [theIOSwitch target];
  [theIOSwitchPop setTarget:self];
  [theIOSwitchPop setAutoupdate:YES];
  [theIOSwitchPop changeButtonTitle:YES];
  [theIOSwitchPop setAction:@selector(takeIOFromMenu:)];
  return self;
}

- init
{
  [NXApp loadNibSection:"UGMethodDef.nib" owner:self withNames:YES];
  xCoord = 0;
  yCoord = 0;
  isOutput = NO;
  theName = NULL;
  return self;
}

- initUGDef: aUGDef
{
  theUGDef = aUGDef;
  return self;
}

- takeXCoordFrom:sender
{
  [self setXCoord:(int) [sender intValue]];
  [theUGDef updateDisplay];
  return self;
}

- takeYCoordFrom:sender
{
  [self setYCoord:(int) [sender intValue]];
  [theUGDef updateDisplay];
  return self;
}

- takeIOFromMenu:sender
{
  char *s;
  /* This is sort of a hack */
  s = (char *) [theIOSwitchPop selectedItem];
  if (s)
    {
      if (strcmp(s, "Output") == 0)
	{
	isOutput = YES;
	}
      else
	{
	  isOutput = NO;

	}
    }

  return self;
}

- takeNameFrom:sender
{
  [self setName:(char *) [sender stringValue]];
  [theUGDef updateDisplay];
  return self;
}

- setXCoord:(int) x
{
  xCoord = x;
  [theXCoordField setIntValue:x];
  return self;
}

- setYCoord:(int) y
{
  yCoord = y;
  [theYCoordField setIntValue:y];
  return self;
}

- setIsOutput:(BOOL) val
{
  isOutput = val;
  return self;
}

- setName:(char *) aName
{
  int len;

  if (! aName || ! (len = strlen(aName)))
    {
      return self;
    }

  if (theName)
    {
      NXZoneFree([self zone], theName);
    }

  len += 10;  // for good measure!
  theName = (char *) NXZoneCalloc([self zone], len, sizeof(char));
  
  strcpy(theName, aName);
  [theNameField setStringValue:aName];
  return self;
}

- (char *) getName
{
  return theName;
}

- (int) xCoord
{
  return xCoord;
}

- (int) yCoord
{
  return yCoord;
}

- (BOOL) isOutput
{
  return isOutput;
}

- updateInspector
{
  if (theName)
    {
      [theNameField setStringValue:theName];
    }
  else
    {
      [theNameField setStringValue:""];
    }

  [theXCoordField setIntValue:xCoord];
  [theYCoordField setIntValue:yCoord];
  [theIOSwitch setTitle:(isOutput ? "Output" : "Input")];
  return self;
}

- edit
{
  sprintf(TempString, "%s %s",
	  [theUGDef getName], theName);
  if (! inspector)
    {
      [NXApp loadNibSection:"UGMethodDef.nib" owner:self withNames:YES];
      [self updateInspector];
    }

  [inspector setTitle:TempString];
  [inspector makeKeyAndOrderFront:self];  
  return self;
}

- closeInspector
{
  if (inspector)
    {
      [inspector performClose:self];
    }
  return self;
}

- write:(NXTypedStream *) stream
{
  [super write:stream];
  NXWriteTypes(stream, "*", &theName);
  NXWriteTypes(stream, "i", &xCoord);
  NXWriteTypes(stream, "i", &yCoord);
  NXWriteTypes(stream, "c", &isOutput);
  NXWriteTypes(stream, "@", &theUGDef);
  return self;
}

- read:(NXTypedStream *) stream
{
  int version;
  id anAppKitObj;
  [super read:stream];

  version = NXTypedStreamClassVersion(stream, "UGMethodDef");
  if (version == 4)
    {
      NXReadTypes(stream, "*", &theName);
      NXReadTypes(stream, "i", &xCoord);
      NXReadTypes(stream, "i", &yCoord);
      NXReadTypes(stream, "c", &isOutput);
      NXReadTypes(stream, "@", &theUGDef);
    }
  else
    {
      /* The first version of this object archived
       * appkit stuff - read them here but don't 
       * save them later.
       */
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "*", &theName);
      NXReadTypes(stream, "i", &xCoord);
      NXReadTypes(stream, "i", &yCoord);
      NXReadTypes(stream, "c", &isOutput);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &theUGDef);
    }

  return self;
}

@end
