/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/


#import <objc/Object.h>
#import <objc/List.h>
#define MAX_STR 512

/* This should go away !! */
typedef enum 
{
  MK_UG,
  CLM_UG,
  PP_UG,
  CLAV_UG,
  MIDI_UG,
  NF_UG
} FakeUGType;

typedef enum 
{
  INT,
  DOUBLE,
  ENV,
  BOOLEAN,
  DSPDATUM,
  PARTIALS
} ArgDataType;


@interface UGDef:Object
{

  /* Variables that define the UG */
  int metaType;                     // This should go away soon ...
  char *nibFile;                    // Alternate nib file for this UG
  char *nameString;                 // nameString is a generic name
  char *typeString;                 // typeString is the actual UG type name
  char *iconName;
  BOOL isEnvelopeHandler; 
  BOOL isADSwitch;
  BOOL isData;
  BOOL isOscg;
  BOOL isSineROM;
  BOOL hasLength;
  BOOL hasConstant;
  BOOL isStorage;
  BOOL isMidi;
  BOOL isClavier;
  BOOL isPatchParameter;
  BOOL isNoteFilter;
  List *methods;                    // List of UGMethodDef
  List *arguments;                  // List of UGArgDef

  /* Variables for editing the thing */
  id inspector;                  // Connected in the nib file
  id theNameField;               // Field where name is entered
  id theNibField;                // Field where nib file path is entered
  id theTypeField;               // Field where type is entered
  id theIconField;               // Field where icon is entered
  id theIconView;                // Connected when init from UGManager
  id theArgField;                // Field for editing arguments
  id argCountField;              // Field for showing total # of args
  id argIndexField;              // Field for index of current arg
  id theMethodField;             // Field for editing methods
  id methodCountField;              // Field for showing total # of methods
  id methodIndexField;              // Field for index of current method
  id theOptionSwitch;            // Matrix of switches
  int currMethod;                // The method # that is in theMethodField
  int currArg;                   // The argument # that is in theMethodField
}

- init;
- free;
- takeNameFrom:sender;
- takeNibFileFrom:sender;
- takeTypeFrom:sender;
- takeIconFrom:sender;
- setName:(char *) aName;
- setMetaType:(int) aType;
- (int) getMetaType;
- (char *)getName;
- setNibFile:(char *) fileName;
- (char *)getNibFile;
- (char *)getType;
- (char *) getIconFile;
- (char *) getMethodFieldValue;
- setTheType:(char *) aType;
- setIconFile:(char *) anIcon;
- showIcon;
- editIcon:sender;
- takeOptionFrom:sender;
- updateOptionSwitch;
- setIsEnvelopeHandler:(BOOL) val;
- setIsADSwitch:(BOOL) val;
- setIsData:(BOOL) val;
- setIsOscg:(BOOL) val;
- setIsSineROM:(BOOL) val;
- setHasLength:(BOOL) val;
- setHasConstant:(BOOL) val;
- setIsStorage:(BOOL) val;
- setIsMidi:(BOOL) val;
- setIsClavier:(BOOL) val;
- setIsPatchParameter:(BOOL) val;
- setIsNoteFilter:(BOOL) val;
- (BOOL) isEnvelopeHandler;
- (BOOL) isADSwitch;
- (BOOL) isData;
- (BOOL) isOscg;
- (BOOL) isSineROM;
- (BOOL) hasLength;
- (BOOL) hasConstant;
- (BOOL) isStorage;
- (BOOL) isMidi;
- (BOOL) isClavier;
- (BOOL) isPatchParameter;
- (BOOL) isNoteFilter;
- methods;
- editNewMethod:sender;
- addNewMethod:(char *) aName;
- switchMethod:sender;
- editCurrentMethod:sender;
- removeCurrentMethod:sender;
- editMethod:(int) meth_num;
- arguments;
- editNewArg:sender;
- addNewArg:(char *) aName;
- switchArg:sender;
- editCurrentArg:sender;
- removeCurrentArg:sender;
- editArg:(int) arg_num;
- edit;
- closeInspector;
- addHelp:sender;
- updateDisplay;
- write:(NXTypedStream *) stream;
- read:(NXTypedStream *) stream;
@end
