/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <stdlib.h>
#import <string.h>
#import <appkit/Application.h>
#import <appkit/Control.h>
#import <appkit/PopUpList.h>
#import "UGArgDef.h"
#import "UGDef.h"

extern char *getAppName();

@implementation UGArgDef

static char TempString[MAX_STR];

+ initialize
 /* Set the version. This can be used in a later version to distinguish older
  * formats when unarchiving documents. 
  */
{
  [UGArgDef setVersion:3];
  return self;
}

- awakeFromNib
{
  theTypeSwitchPop = [theTypeSwitch target];
  [theTypeSwitchPop setTarget:self];
  [theTypeSwitchPop setAutoupdate:YES];
  [theTypeSwitchPop changeButtonTitle:YES];
  [theTypeSwitchPop setAction:@selector(setArgTypeFromMenu:)];
  return self;
}

- init
{
  [NXApp loadNibSection:"UGArgDef.nib" owner:self withNames:YES];
  argType = 0;    /* Make sure this is sync with theTypeSwitch */
  theName = NULL;
  return self;
}

- initUGDef: aUGDef
{
  theUGDef = aUGDef;
  return self;
}

- takeNameFrom:sender
{
  [self setName:(char *) [sender stringValue]];
  [theUGDef updateDisplay];
  return self;
}

- setName:(char *) aName
{
  int len;

  if (! aName || ! (len = strlen(aName)))
    {
      return self;
    }

  if (theName)
    {
      NXZoneFree([self zone], theName);
    }

  len += 10;  // for good measure!
  theName = (char *) NXZoneCalloc([self zone], len, sizeof(char));
  
  strcpy(theName, aName);
  [theNameField setStringValue:theName];
  return self;
}

- takeDefaultValueFrom:sender
{
  [self setDefaultValue:(char *) [sender stringValue]];
  [theUGDef updateDisplay];
  return self;
}

- setDefaultValue:(char *) aDefaultValue
{
  int len;
  char *val;

  if (! aDefaultValue || ! (len = strlen(aDefaultValue)))
    {
      val = "";
      len = 1;
    }
  else
    {
      val = aDefaultValue;
    }

  if (defaultValue)
    {
      NXZoneFree([self zone], defaultValue);
    }

  len += 10;  // for good measure!
  defaultValue = (char *) NXZoneCalloc([self zone], len, sizeof(char));
  
  strcpy(defaultValue, val);
  [theDefaultValueField setStringValue:val];
  return self;
}

- setArgTypeFromMenu:sender
/* This gets called when the user hits the theTypeSwitchPop */
{
  char *s;
  
  s = (char *) [theTypeSwitchPop selectedItem];
  if (s)
    {
      if (strcmp(s, "INT") == 0)
	{
	  argType = INT;
	}
      else if (strcmp(s, "DOUBLE") == 0)
	{
	  argType = DOUBLE;
	}
      else if (strcmp(s, "ENV") == 0)
	{
	  argType = ENV;
	}
      else if (strcmp(s, "BOOLEAN") == 0)
	{
	  argType = BOOLEAN;
	}
      else if (strcmp(s, "DSPDATUM") == 0)
	{
	  argType = DSPDATUM;
	}
      else if (strcmp(s, "PARTIALS") == 0)
	{
	  argType = PARTIALS;
	}
      else
	{
	  NXRunAlertPanel(getAppName(), "Brain fart", NULL, NULL, NULL);
	}
    }

  return self;
}

- setArgType:(int) aType
{
  argType = aType;
  return self;
}

- (char *) getName
{
  return theName;
}

- (int) argType
{
  return argType;
}

- (char *) defaultValue
{
  return defaultValue;
}

- updateInspector
{
  if (theName)
    {
      [theNameField setStringValue:theName];
    }
  else
    {
      [theNameField setStringValue:""];
    }

  if (defaultValue)
    {
      [theDefaultValueField setStringValue:defaultValue];
    }
  else
    {
      [theDefaultValueField setStringValue:""];
    }

  switch (argType)
    {
      case (INT):
	{
	  [theTypeSwitch setTitle:"INT"];
	  break;
	}
      case (DOUBLE):
	{
	  [theTypeSwitch setTitle:"DOUBLE"];
	  break;
	}
      case (ENV):
	{
	  [theTypeSwitch setTitle:"ENV"];
	  break;
	}
      case (BOOLEAN):
	{
	  [theTypeSwitch setTitle:"BOOLEAN"];
	  break;
	}
      case (DSPDATUM):
	{
	  [theTypeSwitch setTitle:"DSPDATUM"];
	  break;
	}
      case (PARTIALS):
	{
	  [theTypeSwitch setTitle:"PARTIALS"];
	  break;
	}
      default:
	{
	  NXRunAlertPanel(getAppName(), "Internal error File: %s Line: %d", 
			  NULL, NULL, NULL, __FILE__, __LINE__);
	}
    }

  return self;
}

- edit
{
  sprintf(TempString, "%s %s",
	  [theUGDef getName], theName);

  if (! inspector)
    {
      [NXApp loadNibSection:"UGArgDef.nib" owner:self withNames:YES];
      [self updateInspector];
    }

  [inspector setTitle:TempString];
  [inspector makeKeyAndOrderFront:self];  
  return self;
}

- closeInspector
{
  if (inspector)
    {
      [inspector performClose:self];
    }
  return self;
}

- write:(NXTypedStream *) stream
{
  [super write:stream];
  NXWriteTypes(stream, "*", &theName);
  NXWriteTypes(stream, "*", &defaultValue);
  NXWriteTypes(stream, "i", &argType);
  NXWriteTypes(stream, "@", &theUGDef);
  return self;
}

- read:(NXTypedStream *) stream
{
  int version;
  id anAppKitObj;
  [super read:stream];

  version = NXTypedStreamClassVersion(stream, "UGArgDef");
  if (version == 3)
    {
      NXReadTypes(stream, "*", &theName);
      NXReadTypes(stream, "*", &defaultValue);
      NXReadTypes(stream, "i", &argType);
      NXReadTypes(stream, "@", &theUGDef);
    }
  else
    {
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "*", &theName);
      NXReadTypes(stream, "*", &defaultValue);
      NXReadTypes(stream, "i", &argType);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &anAppKitObj);
      NXReadTypes(stream, "@", &theUGDef);
      NXReadTypes(stream, "@", &anAppKitObj);
    }

  return self;
}

@end
