/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <stdlib.h>
#import <math.h>
#import <stddef.h>
#import <ctype.h>
#import <string.h>
#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <appkit/Control.h>
#import "Utilities.h"
#import "RegressionTest.h"
#import "Controller.h"
#import "FakeSynthPatch.h"
#import "MKCodeGen.h"

extern char *getAppName();

@implementation RegressionTest

- awakeFromNib
{
  theRegressionDir = (char *) [regressionDirField stringValue];
  theExampleDir =    (char *) [exampleDirField stringValue];
  return self;
}

- init
{
  [super init];
  [NXApp loadNibSection:"RegressionTest.nib" owner:self withNames:YES];
  return self;
}

static char *examplePatches[] = {
    "addamsFamily",
    "am",
    "amSynth",
    "basicsounds",
    "basicstereo",
    "bottle",
    "brass",
    "brassSynth",
    "dualRes",
    "feedback",
    "fm",
    "fmSynth",
    "fullsounds",
    "guitarSynth",
    "karplusStrong",
    "multiControllers",
    "partials",
    "pitchednoise",
    "realam",
    "scaryBirds",
    "stereo",
    "stringPan",
    "waveTableSynth",
    "wobblyWaves"
};

#define NUM_TESTS sizeof(examplePatches)/sizeof(char*)

- displayInspector:sender
{
  [inspector makeKeyAndOrderFront:self];
  return self;
}
 
- setRegressionTestDir:sender
{
  theRegressionDir = (char *) [sender stringValue];
  return self;
}

- setExampleDir:sender
{
  theExampleDir = (char *) [sender stringValue];
  return self;
}

- runRegressionTests:sender
 {
   int i;
   int example_count = NUM_TESTS;
   static char outputFile[1024];
   static char exampleFile[1024];
   static char tempString[4096];
   
   if (!theRegressionDir)
     {
       NXRunAlertPanel(getAppName(), "Set the regression test directory", 
		       NULL, NULL, NULL);
       return self;
     }

   if (!theExampleDir)
     {
       NXRunAlertPanel(getAppName(), "Set the example directory", 
		       NULL, NULL, NULL);
       return self;
     }



   /* Generate all the files */
   for (i=0; i<example_count; i++)
     {
       sprintf(exampleFile, "%s/%s", theExampleDir, examplePatches[i]);
       sprintf(outputFile, "%s/%s.m", theRegressionDir, examplePatches[i]);
       [(Controller *) theController openFile:exampleFile];
       [theMKCodeGen emitCodeTo:outputFile genComments:1 ToDest: -1];
     }


   /* Compile all the example apps sequentially */
   for (i=0; i<example_count; i++)
     {
       sprintf(outputFile, "%s/%s.m", theRegressionDir, examplePatches[i]);
       sprintf(tempString, "%s/mk-tester -no_start -mfile %s -sb_dir %s",
	       [utilities getAppDir], outputFile, [utilities getAppDir]);
       printf("%s\n", tempString);
       system(tempString);
     }

   return self;
 
}
@end
