/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * PatchParam.h
 * Nick Porcaro Summer 1993
 *
 * Patch Parameters (PP's) receive Notes from Midi, the Clavier,
 * or other PP's.  PP's are initialized upon instantiation in the 
 * FakeSynthPatch, and are edited through the PatchParamEditor object
 */

#import <musickit/params.h>
#import <musickit/NoteFilter.h>
#import <musickit/Note.h>

@interface PatchParam:NoteFilter
{
  // Identification
  char theName[256];         // Name of the PP

  // Inspector variables (outlets)
  id inspector;          // The input panel for this PatchParam
  id thePPName;          // Label on the inspector panel.  Can be changed at runtime
  id midiCtrlField;      // Field for the midi controller
  id midiCtrlScale;      // Scale midi controller value by this
  id minMidiCtrlScale;   // Min value for midiCtrlScale
  id maxMidiCtrlScale;   // Max value for midiCtrlScale
  id midiCtrlOffset;     // Offset midi controller value by this
  id minMidiCtrlOffset;  // Min value for midiCtrlOffset
  id maxMidiCtrlOffset;  // Max value for midiCtrlOffset
  id offsetSlider;       // Slider dealing with offset
  id scaleSlider;        // Slider dealing with scale

  // Inspector variables (internal)
  double midiCtrlScaleVal;     // The value from midiCtrlScale
  double minMidiCtrlScaleVal;  // The value from minMidiCtrlScale
  double maxMidiCtrlScaleVal;  // The value from maxMidiCtrlScale
  double midiCtrlOffsetVal;    // The value from midiCtrlOffset
  double minMidiCtrlOffsetVal; // The value from minMidiCtrlOffset
  double maxMidiCtrlOffsetVal; // The value from maxMidiCtrlOffset

  // Map variables (outlets)
  id envDelegate;              // The object that edits the envelope for us
  id mapEnvelope;              // The Envelope object the envDelegate manages
  id enableSwitch;             // Switch to say whether we deal with mapEnvelope or not.


  // Map variables (internal)
  BOOL envelopeNeedsInit;      // YES:  Read the mapEnvelope into envController
  BOOL mapEnabled;          // YES:  Apply the lookup table

  // UG selection variables
  id noteTypeSelector;        // Send control signal when we have (NoteOn, NoteOff, NoteUpdate)
  id ugSelector;              // Pull down that lists the UGs controlled by the PP
  id argSelector;             // Pull down that lists the UGs args capable of being controlled

  // UG selection variables (internal)
  int noteTypeToControl;
  id theFakeUG;              // The FakeUG that we are controlling
  int theArg;                // The index of the arg of theFakeUG that we are controlling

  // The cool stuff: sound related
  id fakeUGs;            // All the fakeUGs in the patch
  id thePatch;           // The FakeFakeSynthPatch object
  int midiController;    // The midi controller to pay attention to
  char midiControllerName[128];  // The string displayed in midiCtrlField
  int midiControllerAsMKParm;    // The midi controller to pay attention to (viewed as an MK parameter)
  id argSelectorPop;
  id ugSelectorPop;

  // Stuff that came from the Ensemble Mapper object
  id paramInterface;
  id inputInterface;
  id envelopeView;

  int clickCount;               // Number of times an instance has been clicked
  BOOL paramEnabled;
  id paramEnabledSwitch;
  NXRect inspectorRect;         // The rectangle the inspector is in
  BOOL inspectorRectJustLoaded; // YES:  the inspectorRect was just read in
  BOOL useInspectorRect;        // YES:  use the inspectorRect that was just read in
  BOOL inspectorDisplayed;      // YES:  the inspector is being displayed
  id theViewFakeUG;             // The fakeUG object that is used to display this PatchParam
  BOOL doHighlight;
  int currNoteCount;            // Number of Notes sent since thinning factor
  int thinFactor;               // Number of Notes sent since thinning factor
  id  thinField;
  id  thinSwitch;
  BOOL thinEnabled;

}

// Methods for init/free and identification
- awakeFromNib;
- init;
- takeThinFactor:sender;
- takeThinEnable:sender;
- takeParamEnabled:sender;
- setPatchParamName: (char *) aName;
- (char *) getName;
- setPatch:aPatch;                   // Sets the FakeSynthPatch, also initializes theFakeUGs
- setViewFakeUG:aFakeUG;             // Sets the theViewFakeUG
- thePatch;                          // Gets the FakeSynthPatch


// Action methods relating to the inspector
- setInspectorTitles;                // Make sure the titles are cool.
- takeNameFrom:sender;               // Set the name of the PP from the inspector window
- takeMidiCtrlFrom:sender;           // Sets midi controller to use
- takeScaleFrom:sender;              // Scale midi controller by this
- takeMinScaleFrom:sender;           // Min scale value
- takeMaxScaleFrom:sender;           // Max scale value
- takeOffsetFrom:sender;             // Offset midi controller by this
- takeMinOffsetFrom:sender;          // Min offset value
- takeMaxOffsetFrom:sender;          // Max offset value
- takeMapEnableFrom:sender;          // Set map enable
- displayInspector;                  // Bring up the inspector window
- selectFakeUG:sender;               // Select theFakeUG from ugSelector
- selectArg:sender;                  // Select theArg from argSelector
- takeNoteType:sender;               // Select noteTypeToControl from noteTypeSelector

// Internal methods relating to the inspector
- setFakeUG:(char *) name;           // Set theFakeUG by name
- getFakeUG:(char *) name;           // Find the FakeUG named name in fakeUGs
- updateUgSelector;                  // Set the ugSelector with the names of all the fakeUGs
- setArg:(char *) name;              // Set theArg by name
- (int) getIndexForArg:(char *) name FromFakeUG:aFakeUG;   // What it says
- updateArgSelector;                 // Set the argSelector with all arg names in theFakeUG
- inspectorClosed;
- closeInspector;
- highlightSelf;

// Methods relating to the map

- createDefaultMapEnvelope;
- syncMapEnvelope;                   // Make sure the mapEnvelope is happy
- setMapEnvelope:anEnv;
- clearMapEnvelope;
- displayMapEnvelope:sender;         // Bring up the map envelope editor window

// Methods for dealing with actually making the sound
- setParamValue:(double)ctrl_val;     // Set theArg to ctrl_val
- realizeNote:aNote fromNoteReceiver:aNR;

// Stuff that came from the Mapper

/* - editEnvelope:sender; */

- displayIfDoubleClick;

- displayInspectorIfWasActive;
@end
