/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * NoteOnHandler.m
 */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <appkit/Panel.h>
#import <musickit/params.h>
#import <musickit/Performer.h>
#import <musickit/Note.h>
#import <musickit/NoteFilter.h>
#import <musickit/NoteSender.h>
#import <musickit/Conductor.h>
#import <musickit/Orchestra.h>
#import <musickit/Conductor.h>
#import <musickit/UnitGenerator.h>
#import "NoteOnHandler.h"
#import "FakeSynthPatch.h"
#import "FakeUG.h"

extern char *getAppName();

@implementation NoteOnHandler

- init
{
  [super init];
  [self addNoteSender:[[NoteSender alloc] init]];
  [self addNoteReceiver:[[NoteReceiver alloc] init]];
  return self;
}

- initConnection:aSP
{
  /* theSP should be connected in the nib file */
  theSP = aSP;
  if (! theSP)
    {
      NXRunAlertPanel(getAppName(), 
	"Internal snafu nil theSP in NoteOnHandler", NULL, NULL, NULL);
    }
  return self;
}

- realizeNote:aNote fromNoteReceiver:nr
{

  [[self noteSender] sendNote:aNote];
  switch ([aNote noteType]) 
    {
    case MK_noteOn:
      {
	/* broadcast 'noteOn' */
	[theSP noteOn:self];
	break;
      }
    case MK_noteOff:
      {
	/* broadcast 'noteOff'  */
	[theSP noteOff:self];
	break;
      }
    default:
      {
	/* Nothing for now */
	break;
      }
    }

  return self;
}

@end
