/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * NodeView.h
 * Eric Jordan, independent work, Spring, 1992
 * Each point of connection between icons on the screen corresponds to a
 * an instance of a "NodeView" object.
 */

#import <appkit/View.h>
#import <appkit/graphics.h>

#ifdef NEXT_2_0 
#import <nextdev/event.h>
#else
#import <dpsclient/event.h>
#endif

@interface NodeView : View
{
  /* Holds the connection number. */
  int tag;
/* 
 * The system always sends a mouse up to the same object that got the
 * mouse down;  the following boolean helps us redirect that mouse up
 * to the object that the cursor is in.
 */
  BOOL redirectNextMouseUp;
  id thePatch;         // We need this to know where we are!
}

/* The tag should be set just after initialization. */

-setPatch:aPatch;
-setTag:(int)newTag;  /* The tag is the method index */
-(int)getTag;

- (BOOL) isAnOutput;

/* Return the frame.  (Needed by FakePatchPoint.) */
-(NXRect)frame;

-(BOOL)acceptsFirstMouse;
-drawSelf:(const NXRect *)rects :(int)rectCount;
-mouseDown:(NXEvent *)theEvent;
-mouseDragged:(NXEvent *)theEvent;
-mouseUp:(NXEvent *)theEvent;

@end
