/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * MKCodeGen.h
 *
 * Music Kit Code generator object (split off from FakeSynthPatch)
 */

@interface MKCodeGen : Object
{
  id theSP;                  // Gotten from theController
  id theMainController;      // Connected in nib
  id fakeUGs;
  id fakePatchPoints;
  id patchDest;
  id generateComments;
  id testerScript;
  id theInspector;
  id utilities;             // Utilities object
}

- displayInspector:sender;
- emitCode:sender;
- emitCodeTo:(char *) file genComments:(int) comments ToDest: (int) aDest;
- (char *) makeHeaderFile:(char *)fileName;
- (char *) makeObjCCode:(char *)fileName:(int)generateComments;
- (char *)setClassNameFromFileName:(char) suff : (char *) fileName;
- (char *)checkForUnconnectedPins: (int) index;
@end
