/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <stdlib.h>
#import <appkit/Matrix.h>
#import <dpsclient/psops.h>
#import <dpsclient/wraps.h>
#import "IconView.h"

@implementation IconView

+initialize
{
  return self;
}

-init
{
  [super init];
  return self;
}

- showImageInFile: (char *) file
{
  id anImage;
  if (! file)
    {
      return self;
    }

  anImage = [NXImage findImageNamed:file];
  if (! anImage)
    {
      return self;
    }

  [self showImage:anImage];
  return self;
}

- showImage:anImage
{
  NXRect *rect = (NXRect *)NXZoneMalloc([self zone], sizeof (*rect));
  NXPoint *thePoint = (NXPoint *) NXZoneMalloc([self zone], sizeof (*thePoint));

  [self lockFocus];
  rect->origin.x = frame.origin.x;
  rect->origin.y = frame.origin.y;
  rect->size.width = frame.size.width;
  rect->size.height = frame.size.height;
  [self convertRectFromSuperview:rect];
  PSsetgray(NX_LTGRAY);
  NXRectFill(rect);
  thePoint->x = thePoint->y = 0.0;
  if (anImage)
    {
      [anImage composite:NX_SOVER toPoint:thePoint];
    }

  NXPing();
  [self unlockFocus];
  return self;
}

-drawSelf:(const NXRect *)rects :(int)rectCount
{
  return self;
}

@end
