/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import "GenericCell.h"
#import "GenericObject.h"
#import "ViewController.h"
#import <dpsclient/psops.h>
#import <objc/hashtable.h>
#import <stdlib.h>
#import <stdio.h>

#define FIELD1_LMARGIN 4.0
#define FIELD2_LMARGIN 54.0

@implementation GenericCell

- init
{
  [super init];
  [self setType:NX_TEXTCELL];
  [self setTarget:[ViewController theViewController]];
  [self setAction:@selector(gotItMan:)];
  return self;
}

- genericObject
{
  return genericObject;
}

- setGenericObject:anObject
{
  genericObject = anObject;
  return self;
}

- setFont:fontObj
{
  [super setFont:fontObj];
  /*
   * save this info so we don't have to look it up every time we draw
   * Note:  support for a TextCell is a font object
   */
  NXTextFontInfo(support, &ascender, &descender, &lineHeight);
  return self;
}    

- drawInside:(const NXRect *)cellFrame inView:controlView
{
  NXCoord	baseX, baseY;

  baseX = NX_X(cellFrame);
  baseY = NX_Y(cellFrame) + lineHeight - descender;
     
  /* erase the cell */
  PSsetgray((cFlags1.state || cFlags1.highlighted) ? NX_WHITE : NX_LTGRAY);
  NXRectFill(cellFrame);

  PSsetgray(NX_BLACK);
  /* draw the start, duration, and mark name in black */
  PSmoveto(baseX + FIELD1_LMARGIN, baseY);
  PSshow([genericObject getName]);

  return self;
}

@end
