/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * FakeUG.h
 * Eric Jordan, independent work, Spring, 1992
 * Each icon on the screen corresponds to a "fake unit generator".
 * We must use a fake unit generator, instead of a real one as provided
 * by the music kit, in order to have the ability to recall what connections
 * have been made.  In order to save typing, all of the graphical unit
 * generators are instances of fakeUG (as opposed to making fakeug an abstract
 * type, with subclasses fakeOscg, fakeASympu, etc.)
 * Also, eventually, some things will be fake unit generators that are not
 * actually unit generators, such as note parameters and constants.
 */

#import <appkit/View.h>
#import <appkit/graphics.h>
#import <dpsclient/event.h>
#import <appkit/NXImage.h>
#import "NodeView.h"

/* 
 * None of the generators have more than 4 inputs and 1 output (that should
 * be hooked up to another fake unit generator, that is.)
 */
#define MAXCONNECTIONS 10         /* Don't be so damn cheap */
#define MAXNOTEPARAMETERS 20      /* Don't be so damn cheap */
#define ORCH_SAMPLING_RATE 44100

/* Hacks to get the frequency of an oscillator
 * that bases its frequency on a phase increment
 */
#define HACK_DEFAULT_INC_RATIO 1
#define HACK_MK_OSCFREQSCALE 256.0 /* Used by Oscg and Oscgaf */
#define HACK_DEFAULT_TABLE_LENGTH 256
/*
 * How many characters to allow for when callocing to create a string that
 * represents the name of a unit generator.
 */
#define MAXUGNAMELENGTH 20
#define MAX_UG_NAME_LEN 256

@interface FakeUG : View
{
  id theUGDef;                                  // The definition for this FakeUG
  List *theMethods;                             // The methods
  List *theArgs;                                // The arguments
  int methodCount;                              // The number of methods
  int argCount;                                 // The number of arguments
  id connections[MAXCONNECTIONS];               // An array of fakePatchPoints
  char *arg[MAXNOTEPARAMETERS];                 // Arguments to be sent to the methods.
  BOOL argEnabled[MAXNOTEPARAMETERS];           // Do we send the argument or not?
  id argEnabledSwitch;                          // Switch on inspector for argEnabled
  id theImage;
  char theName[256];                            // The instance name
  NXPoint whereGrabbed;                         // Used for dragging.
  BOOL noMovement;                              // YES: make this the selected object.
  BOOL erasing;                                 // When doing eraseSelf, tell drawSelf to do nothing
  BOOL mouseUpRespond;                          // YES: Avoid responding to extraneous mouseUp's.
  id ug;                                        // The actual unit generator running on the dsp
  id patchParam;                                // The PatchParameter object if there is one
  id clavier;                                   // The Clavier object if there is one
  id midi;                                      // The MIDI inspector if there is one
  id noteFilter;                                // The NoteFilter inspector if there is one
  BOOL isAllocated;                             // YES:  The ug has been allocated
  BOOL isSoundMaker;                            // YES:  It can make sound
  id theSP;                                     // The FakeSynthPatch we are part of
  id inspector;                                 // The parameter inspector
  id noArgInspector;                            // The parameter inspector if no args
  id argVal;                                    // Value of the arg on inspector
  id argName;                                   // Name of the arg on the inspector
  id argIndexField;                             // Display for arg index in the inspector
  id argCountField;                             // Display for arg count in the inspector
  int currArg;                                  // Index of current arg on the inspector
  id argButton;                                 // The button next to the args
  id fakeUGName;                                // Name of the fake UG on the inspector
  id fakeUGType;                                // Type of the fake UG on the inspector
  id fakeUGNameNoArg;                           // Name of the fake UG on the noArgInspector
  id fakeUGTypeNoArg;                           // Type of the fake UG on the noArgInspector
  id envDelegate[MAXNOTEPARAMETERS];            // Envelope editor delegate
  id argEnvelope[MAXNOTEPARAMETERS];            // Envelopes for the arguments
  id slider[MAXNOTEPARAMETERS];                 // UGArgSlider for the args
  BOOL clavInit;                                // YES: the clav connection is inited
  int allocOrder;                               // The order the ug is allocated
  id allocOrderField;                           // Field on the inspector for allocOrder
  id allocOrderField2;                          // Field on the noarg insp for allocOrder
  int clickCount;                               // Number of times an instance has been clicked
  NXRect inspectorRect;                         // The rectangle the inspector is in
  BOOL inspectorRectJustLoaded;                 // YES:  the inspectorRect was just read in
  BOOL useInspectorRect;                        // YES:  use the inspectorRect that was just read in
  BOOL inspectorDisplayed;                      // YES:  the inspector is being displayed
  BOOL doHighlight;
}


- init;

- takeAllocOrderFrom:sender;

- takeArgEnableFrom:sender;

- (BOOL) isArgEnabled:(int) num;

- setAllocOrder:(int) order;

- (int) getAllocOrder;

- updateAllocOrder;

- closeInspector;

- setSP:aSP;

- getSP;
 
- initWithDef: aUGDef WithPatch:aSP;

- initUGDef: aUGDef;

- setDefaultValues;

- initSubviews;

- checkSubviews;

- displayArg:(int) i;

- checkConnections;

- printConnections;

- validate;

- getImage;

- (BOOL)getErasing;

- (char *)getName;

- changeName:(char *)newName;

- takeNameFrom:sender;

- (char *)getTypeString;
/* Given a fakeUG, return its type as a string, e.g. "OscG". */

- (char *)getGenericTypeString;

- (BOOL)isAFakeUG;

- (BOOL)isAFakePatchPoint;

- (char *)getConnectionName:(int)connectionNumber;
/* Given a fakeUG, and a connection number, return, as a string, the
 * name of the message that the UG corresponding to self should get in
 * order to set that connection.
 */

- setConnection:(int)connectionNumber toFakePatchPoint:fakePatchPoint;
/* Make a connection from self to head using connection number
 * connectionNumber.
 */

- getConnection:(int)connectionNumber;
/* Return the fake patch point that is connected to connection number
 * connectionNumber, nil if none.
 */

- getUG;

- (int)getArgType:(int)i;

- allocateUGMK;

- runMK;

- deallocUGMK;

- (BOOL)isEnvelopeHandler;

- (BOOL)isDSwitch;

- (BOOL)isData;

- (BOOL)isStorage;

- (BOOL)isOscg;

- (BOOL)isSineROM;

- (int)getLength;
/* The length, if it is a SynthData. */

- (BOOL)hasConstant;

- (char *)getConstant;

- setConstantPP:(double) value;

- (BOOL)isComplete;

- (BOOL)acceptsFirstMouse;

- (BOOL)acceptsFirstResponder;

- drawSelf:(BOOL)instance;
/* Basic drawing routine, used by many of the routines below. */

- eraseSelf;

- removeSelf;

- remConnection:(int)i;

- nilConnectionsWithId:aFakePatchPoint;

- drawSelf:(const NXRect *)rects :(int)rectCount;

- mouseDown:(NXEvent *)theEvent;

- mouseDragged:(NXEvent *)theEvent;

- mouseUp:(NXEvent *)theEvent;

- getInspectorRect:anInspector;

- write:(NXTypedStream *) stream;

- read:(NXTypedStream *) stream;

- (STR)getArgCast:(int)type;

- (STR)getArgTypeStr:(int)type;

- (int)getUGTarget; // Is it a CLM UG or MK UG ?

- (BOOL) isPatchParameter;

- (BOOL) isClavier;

- (BOOL) isMidi;

- (BOOL) isNoteFilter;

- thePatch;                            // Return the patch

- clavier;                             // Return the Clavier

- midi;                                // Return the midi

- noteFilter;                          // Return the noteFilter

- patchParam;                          // Return the patchParam

- (BOOL) isSoundMaker;                 // YES: It can make sound

- setInspectorName:(char *) aName;

- switchArg:sender;

- displayInspector;

- displayInspectorIfWasActive;

- inspectorClosed;

- bringUpInspector:anInspector;

- takeArgFromInspector:sender;

- inspectArg:sender;

- syncEnvelope:(int) i;

- createDefaultEnvelope:(int) i;

- displayEnvelope:(int) i;

- inspector;

- setArg: (int) argnum To:(char *) value;

- setArgWithIndex:(int) argnum To:(char*) value;

- setArg:(int)i WithEnvelope:anEnv;

- sendArg:(int) num;

- (STR)getArg:(int)i;

- getArgEnvelope:(int)i;

- clearArgEnvelope:(int)i;

- willAddEnvelope:(int)i;

- willRemoveEnvelope:(int)i;

- (int) methodCount;

- (int) getArgCount;

- (char *)getMethod:(int)i;

- (char *)getArgName:(int)i;

- (BOOL) isMethodAnOutput:(int)i;

- printSelf;

- displayIfDoubleClick;

- highlightSelf;

- setDoHighlight:(BOOL) flag;

@end
