/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/* EnvDelegate.h
 * Nick Porcaro, independent work Summer 1993
 */

#import <objc/Object.h>

@interface EnvDelegate:Object
{
    id envController;         // The Envelope controller (connected when nib loaded)
    id envelope;              // The envelope object (connected when nib loaded)
    char *envString;          // The string representing the envelope
    id envWindow;             // The window the envelope is being edited in
    id theFakeUG;             // The FakeUG associated with the envelope (if there is one)
    id thePatchParam;         // The PatchParam associated with this envelope (if there is one)
    int theArgNum;            // The arg number on theFakeUG associated with the envelope
}

- init;                                   // As always ...
- closeInspector;
- setFakeUG:aFakeUG ArgNum: (int) argnum; // Tell the delegate which fake ug and arg
- setPatchParameter:aPP;                  // Tell the delegate which PatchParameter
- (BOOL) hasFakeUG;                       // Do we have a fake ug or what?
- displayWindow:(char *) title;           // Display the window for the envelope
- (char *) envelopeToText;                // Return envelope  as a (char *)
- textToEnvelope: (char *) aString;       // Convert a text string to an envelope object
- envelope;                               // Return the envelope object
- sendEnvelope;                           // Send the latest envelope to the FakeUG or PatchParam
- envController;                          // Return the controller object
- envelopeRemoved;                        // The envController removed the envelope
- willAddEnvelope;                        // The envController is about to add an envelope
- willRemoveEnvelope;                     // The envController is about to remove an envelope
- willSplitView;                          // The envController is about to split views
- envelopeAdded;                          // The envController added an envelope
@end



