/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * Controller.h
 * Eric Jordan, independent work, Spring, 1992
 */

#import <objc/Object.h>
#define MAXNAMESIZE 100

@interface Controller:Object
{

  // Outlet variables
  id theSP;               // This is a FakeSynthPatch when it gets read in
  id theWindow;           // theSP's window       
  id dragView;            // the icon well where elements get placed
  id helpWindow;          // Help window -- init'ed from Help.nib
  id infoPanel;           // Info panel  -- init'ed from Info.nib
  id theClmCodeGen;       // CLM code generator (instantiated/connected in nib)
  id theMKCodeGen;        // Object for generating mk code (instantiated/connected in nib)
  id soundHidingPref;     // The switch for stopSoundOnHide
  id theElementController;  // Deals with UG/NG/NF stuff
  id adminPanel;           // Panel with commands for developers
  id legalPanel;           // Panel with legal notice
  id utilities;           // Connected in nib
  id renamePPSwitch;     // ON:  Rename patch points on open

  // Delegates
  id mainWindowDelegate;

  // Internal variables
  char *currentFileName;  // Name of the file of theSP
  BOOL stopSoundOnHide;   // YES:  Release DSP when hidden
}

+ theController;
- awakeFromNib;
- init;
- displayMainWindow;
- setHidingScene:sender;
- newSP:sender;
- open:sender;
- openFile:(char *) fileName;
- fixPatchPointNames;
- save:sender;
- saveAs:sender;
- doSave:(char *)fileName;
- setFileName:(char *) file;
- removeSelected:sender;
- setNameOfSelectedObject:sender;
- getHelp:sender;
- getInfo:sender;
- theSP;
- elementController;
- displayAdminPanel:sender;
- changeMidiPort:sender;
- showLegal:sender;
@end

@interface Controller(ApplicationDelegate)
- appDidInit:sender;
- appDidResignActive:sender;
- appWillTerminate:sender;
@end


