/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <objc/Object.h>

@interface Clavier : Object
    /* A Performer-like object that has three graphic piano octaves
     * with keys that can be clicked on.
     */
{
    id  noteOnHandler;          // The thing that sends the run message to all ugs (see nib)
    id  aNote;                  // The note we send
    id  theSP;                  // The FakeSynthPatch we are connected to (see nib)
    id  theFakeUG;              // The FakeUG we are connected to
    id  theController;          // The Controller (get from theSP)
    id  pianoOctave1;           // Three PianoOctave controls
    id  pianoOctave3;
    id  pianoOctave2;
    id  pitchBendSlider;        // Our special centering slider
    id  pitchBendSens;          // Field with pitch bend sensitivity in it
    id  toggleSwitch;           // Switch to toggle size of inspector
    double pitchbendSensitivity;
    id  modWheelSlider;         // A regular slider
    id  octaveDisplayer;        // Displays octave of lowest PianoOctave
    id  noteSender;             // For sending notes like a performer
    id  inspector;              // The Clavier window
    int lastModVal;
    int lastPitchVal;        
    int octave;                 // The base octave
    int noteTags[128];          // array of unique note tags
    char theName[256];          // The name of this clavier
    id  theNameField;           // Text field for theName
    int clickCount;
    NXRect inspectorRect;       // The rectangle the inspector is in
    BOOL inspectorRectJustLoaded;  // YES:  the inspectorRect was just read in
    BOOL useInspectorRect;      // YES:  use the inspectorRect that was just read in
    BOOL inspectorDisplayed;    // YES:  the inspector is being displayed
    BOOL doHighlight;
}

- init;

- initConnectionWithPatch:aSP WithFakeUG: aFakeUG;

- displayInspector;

- displayIfDoubleClick;

- displayInspectorIfWasActive;

- inspectorClosed;

- closeInspector;

- highlightSelf;

- toggleInspector:sender;

- inspector;

- noteSender;

- connectNoteSenderTo:aNoteReceiver;

- noteOnHandler;

- takeNameFrom:sender;

- setClavierName: (char *) aName;

- (char *) getName;;

- takeOctaveFrom:sender;

- takeKeyValueFrom:sender;

- takeModWheelFrom:sender;

- takePitchBendFrom:sender;

- takeSostenutoFrom:sender;

- write:(NXTypedStream *) stream;

- read:(NXTypedStream *) stream;

@end

