/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/* CellScrollView.h:
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 *
 * The CellScrollView is a subclass of scrollview that maintains a set of
 * custom cells in a matrix.  The contents of each cell is derived from an
 * external list of objects.  This approach separates the underlying data
 * structure from the user interface.
 */

#import <appkit/appkit.h>
#import <objc/List.h>


@interface CellScrollView:ScrollView
{
  id	cellMatrix;		/* underying matrix of FooCells */
  Class  theCellClass;
  List  *theCellList;
  const NXRect *theFrameRect;
  id theViewController;
}

- init;

- initFrame:(const NXRect *)frameRect;

- initCellList:aList;

- setCellList:aList;

- initCellMatrix;

- initCellMatrixWithClass:(Class) aClass;

- reportCurrentSelection;

- currentlySelectedObject;

- free;

- cellMatrix;

- deleteSelections;

- editSelections;

- objectsJustAdded;

- updateList;

- getCurrentImage;

- (BOOL) haveSelection;

- getImageFor:anObject;

@end
