/* CompletionView.h
 * CompletionView is a simple "gas gauge" display to display the proress
 * of some calclation.  As you call [compltionView setDoubleValue:value]
 * with values of 0.0 to 1.0, the completion view go from empty to full.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Robert Poor
 * Created: Sep/92
 */

#import <appkit/View.h>

@interface CompletionView:View
{
  double	value;		/* 0.0 <= value < 1.0 */
  int		pctValue;	/* value expressed from 0 to 100 % */
  float		backgroundColor;
  float		completionColor;
  id		textField;
  BOOL		updateTextField;
}

- initFrame:(const NXRect *)frameRect;

- (double)value;
- setDoubleValue:(double)aValue;
/*
 * Value is assumed to range between 0.0 and 1.0
 */

- (float)backgroundColor;
- setBackgroundColor:(float)color;
- (float)completionColor;
- setCompletionColor:(float)color;
/*
 * Get/Set the colors used for to draw the gauge.
 */

- textField;
- setTextField:aTextField;
/*
 * If there is an object that responds to setStringValue, then the completion
 * view will update it's text with a string of the form "nn%" whenever its
 * value changes.
 */

- drawSelf:(NXRect *)rects :(int)rectCount;

@end
