;;; To be used with NeXT Scorefile Package Version 3
;;; Similar to examp8, but with chorusing.

(require :scorefile)
(use-package 'scorefile)
(score examp9 ((tempo 42)) nil)
(header "
envelope smooth  = [(0,0)(.3 ,1.0)|(1.0,0.0)];
envelope ramp01 =  [(0,0)(.3,1)];
envelope ramp10 =  [(0,1)(.3,0)];
" )

(defmacro firstnote () '(= (notenum) 1))

(dotimes (i 2) ; basses
  (part nil
	("DBWave2vi" (synthPatchCount 1))
	(+ (random .2) 0 )
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.5 .25 .75 .5))) :quiet) 
	(time (accumulate-durs) :quiet)
	(timeTag '(max (+ (pval time) -.01 (random .02)) 0))
	(freq1  '(* (+ (random .02) 1.0)(eval (seq (pitches d2 e f g a bf d3 e a bf a :end)))))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0BE" "BU" "0BU" "BE" "0BE" "BE"))
		   :string :always)
	(waveform1 '(cycle '("BA" "0BA" "BO" "0BO" "BA" "0BA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .015)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing (+ (* i 90) -45))
	)
  )

(dotimes (i 2) ; tenors
  (part nil
	("DBWave2vi" (synthPatchCount 1))
	(+ (random .2) .5)
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(1.0 .25 .5 .25))) :quiet) 
	(time (accumulate-durs) :quiet)
	(timeTag '(max (+ (pval time) -.01 (random .02)) 0))
	(freq1  '(* (+ (random .02) 1.0)(eval (seq (pitches f3 e a g c4 d f g a :end)))))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0TE" "TU" "0TU" "TE" "0TE" "TE"))
		   :string :always)
	(waveform1 '(cycle '("TA" "0TA" "TO" "0TO" "TA" "0TA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .015)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing (+ (* i 90) -45))
	)
  )

(dotimes (i 2) ; sopranos
  (part nil				; Generate names automatically
	("DBWave2vi" (synthPatchCount 1))
	(+ 1.5 (random .2))
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.5 .25 .5 .75))) :quiet) 
	(time (accumulate-durs) :quiet)
	(timeTag '(max (+ (pval time) -.01 (random .02)) 0))
	(freq1  '(* (+ (random .02) 1.0)(eval (seq (pitches g5 a f e c d e a4 :end)))))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0SE" "SU" "0SU" "SE" "0SE" "SE"))
		   :string :always)
	(waveform1 '(cycle '("SA" "0SA" "SO" "0SO" "SA" "0SA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .015)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing (+ (* i 90) -45))
	)
  )

(write-score examp9)
(play)
