;;; To be used with NeXT Scorefile Package Version 3
;;; This example uses the NeXT Timbre Data Base in a monophonic context.
;;;      Notice that the perceived timbre remains relatively constant,
;;;      despite the pitch changes. Compare this to munchkin.lisp, where 
;;;      the same wave table is used on every note. 
;;;      Also compare this to examp6.lisp which uses true
;;;      DSP wavetable interpolation and thus avoids the little clicks that
;;;      appear in this example.

(require :scorefile)
(use-package 'scorefile)
(score examp5)		
(header "
envelope bumps   = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];
envelope freqEnvelope   = [(0,.98)(.2,1.0)|(.4,.99)];

" )

(part nil	                        ; Generate names automatically
	("DBWave1vi" (headroom .2))       ; Here's the part info
	0		; Time specification
	:noteOn	
	(dt '(cycle '(.5 .25 .75 .5)) :quiet) 
	(timetag (accumulate-durs dt))
	(freq  '(seq (pitches d2 e f g a bf d3 e :end)))
	(ampEnv "bumps")
	(waveform "BA" :string :always)
	(freqEnv "freqEnvelope")
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	)

(write-score examp5)
(play)
