
/* Generated by Interface Builder */

#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <appkit/FormCell.h>
#import <sound/soundstruct.h>
#import <sys/file.h>
#import "SoundInfo.h"
#import "sfheader.h"

extern int open(), read();
extern void close();
extern char *rindex();

@implementation SoundInfo

+ new
{
	self = [super new];
	[NXApp loadNibSection:"SoundInfo.nib" owner:self];
	return self;
}

- display:(SNDSoundStruct *)sndhdr title:(char const *)title
{
	int ssize, channels, frames, hours, minutes;
	float seconds;
	char *format, time[32];
	SFHEADER *sfhdr;
	
	[siPanel setTitle:title];
	[siSize setIntValue:sndhdr->dataSize];
	[siRate setIntValue:sndhdr->samplingRate];
	channels = sndhdr->channelCount;
	[siChannels setIntValue:channels];
	if (channels < 1) channels = 1;
	switch (sndhdr->dataFormat) {
		case SND_FORMAT_MULAW_8:
		case SND_FORMAT_MULAW_SQUELCH:
			format = "8-bit muLaw";
			ssize = 1;
			break;
		case SND_FORMAT_LINEAR_8:
			format = "8-bit linear";
			ssize = 1;
			break;
		case SND_FORMAT_LINEAR_16:
			format = "16-bit linear";
			ssize = 2;
			break;
		case SND_FORMAT_LINEAR_24:
			format = "24-bit linear";
			ssize = 3;
			break;
		case SND_FORMAT_LINEAR_32:
			format = "32-bit linear";
			ssize = 4;
			break;
		case SND_FORMAT_FLOAT:
			format = "32-bit floating pt";
			ssize = 4;
			break;
		case SND_FORMAT_DOUBLE:
			format = "64-bit floating pt";
			ssize = 8;
			break;
		case SND_FORMAT_INDIRECT:
			format = "Fragmented";
			ssize = 8;
			break;
		default:
			format = "DSP?";
			ssize = 8;
			break;
		}
	[siFormat setStringValue:format];
	frames = sndhdr->dataSize / ssize / channels;
	[siFrames setIntValue:frames];
	seconds = (float) frames / (float) sndhdr->samplingRate;
	hours = (int) (seconds / 3600);
	minutes = (int) ((seconds - hours * 3600) / 60);
	seconds = seconds - hours * 3600 - minutes * 60;
	sprintf (time, "%02d:%02d:%05.2f", hours, minutes, seconds);
    	[siTime setStringValue:time];
	sfhdr = (SFHEADER *) sndhdr;
	if ((sndhdr->dataLocation == SIZEOF_HEADER) &&
	    (sfhdr->sfinfo.sf_magic == SF_MAGIC))
		[siCSound setStringValue:"YES"];
	else [siCSound setStringValue:"NO"];
	[siPanel makeKeyAndOrderFront:self];
	[NXApp runModalFor:siPanel];
	return self;
}

- displaySound:soundobj title:(char const *)title
{
	[self display:[soundobj soundStruct] title:title];
	return self;
}

- (BOOL)displaySoundFile:(char const *)path
{
	int fd;
	SFHEADER sndhdr;
	char const *title;
	
	if ((fd = open (path, O_RDONLY)) < 0) return NO;
	if (read (fd, &sndhdr, sizeof (sndhdr)) < sizeof (SNDSoundStruct))
		return NO;
	close (fd);
	if (sndhdr.sfinfo.NeXTheader.magic != SND_MAGIC) return NO;
	if ((title = rindex (path, '/')) == NULL) title = path;
	else title++;
	[self display:(SNDSoundStruct *)&sndhdr title:title];
	return YES;
}

- windowWillClose:sender
{
	[NXApp stopModal];
	return self;
}

- setSiSize:anObject
{
    siSize = anObject;
    [siSize setSelectable:NO];
    [siSize setEditable:NO];
    return self;
}

- setSiCSound:anObject
{
    siCSound = anObject;
    [siCSound setSelectable:NO];
    [siCSound setEditable:NO];
    return self;
}

- setSiFrames:anObject
{
    siFrames = anObject;
    [siFrames setSelectable:NO];
    [siFrames setEditable:NO];
    return self;
}

- setSiFormat:anObject
{
    siFormat = anObject;
    [siFormat setSelectable:NO];
    [siFormat setEditable:NO];
    return self;
}

- setSiTime:anObject
{
    siTime = anObject;
    [siTime setSelectable:NO];
    [siTime setEditable:NO];
    return self;
}

- setSiRate:anObject
{
    siRate = anObject;
    [siRate setSelectable:NO];
    [siRate setEditable:NO];
    return self;
}

- setSiPanel:anObject
{
    siPanel = anObject;
    [siPanel setDelegate:self];
    return self;
}

- setSiChannels:anObject
{
    siChannels = anObject;
    [siChannels setSelectable:NO];
    [siChannels setEditable:NO];
    return self;
}

@end
