.TH LPC-NeXT UVA
.SH NAME
LPC \- a NeXT adaptation, with graphic user interface, of Paul Lansky's
software for linear predictive analysis and pitch tracking
.SH SYNOPSIS
.B LPC (from shell or NeXT Workspace)
.SH DESCRIPTION
.PP
.I LPC 
performs linear predictive and pitch tracking analyses respectively on
a monaural shortsam or float soundfile. The soundfile analyzed must
have a valid NeXT soundfile header. NeXT-CSound uses a modified IRCAM-type
header whose first element is a NeXT header. The two resulting data files
may then be merged in a manner suitable for use in a
.I CSound
instrument via the
.I lpread
and
.I lpreson
units. The analysis data may be displayed in a scrolling text
window.
.PP
Parameters and interface gadgets are described in more detail below.
.SH LP Analysis
.PP
.I Poles
- Number of poles for analysis.  Default is 34 poles, which is also the
maximum allowed.
.br
.sp
.I Frame Offset
- Offset in samples between analysis frames.  Default 
200 samples, maximum is 505 samples. The actual analysis framesize will
be twice this number. Alternatively, the user may specify frame rate, below.
.br
.sp
.I Frame Rate
- This is simply the soundfile's sampling rate divided by the frame
offset (above). The values displayed for frame offset and frame rate are
each automatically computed to reflect the other.
.br
.sp
.I Skip Time
- Initial seconds of sound to skip over.  Default 0.0.
.br
.sp
.I Duration
- Duration in seconds to analyze.  Default 1.0.
.br
.sp
.I Comment
- Text for the comment field of the lpfile header.
In the default case this is left empty.
.br
.PP
.SH Pitch Tracking
.PP
.I Frame Size
- Analysis frame size in samples.  Default, maximum 
is 1010 samples.  Should be able to contain one
period of the expected pitch.
.br
.sp
.I Frame Offset
- The offset in samples between successive frames. Default 200. This
should be less than half the frame size, above. Setting the frame offset
in the LP analysis section will duplicate the setting for the pitch
tracking section. The pitch tracking frame offset may then be set
independently if desired.
.br
.sp
.I High Estimate
- High pitch estimate in cps (default 1000).
.br
.sp
.I Low Estimate
- Low pitch estimate in cps (default 100).
The better the HIGHPITCH and LOWPITCH estimates are, 
the better the quantization will be in the analysis.
.br
.sp
.I Skip Time
- Initial seconds of sound to skip over.  Default 0.0.
.br
.sp
.I Duration
- Duration in seconds to analyze.  Default 1.0.
.br
.PP
.SH File Buttons
.PP
.I Sound
- register and check a soundfile for analysis.
Some systems support remote soundfile access.  This is not one of them.
.br
.sp
.I LP
- register and check a previously produced linear predictive analysis
data file. This allows the merging of lp and pitch analysis files
produced from the analyses of different soundfiles. If a soundfile
is registered and there exists a file of identical path except for
a '.lp' suffix, that file is assumed to contain lp analysis data for
the soundfile, and is automatically registered as well.
.br
.sp
.I Pitch
- register and check a previously produced pitch tracking analysis
data file. Functioning is as for LP, above, except with a '.pt' suffix.
.PP
.SH Analysis Buttons
.PP
.I LP
- commence linear predictive analysis on the soundfile named in the
soundfile text form, according to the parameters in the LP Analysis
parameter section.
.br
.sp
.I Pitch
- commence pitch analysis on the soundfile named in the
soundfile text form, according to the parameters in the Pitch Tracking
parameter section.
.br
.sp
.I Merge
- merge the pitch data in the file named in the pitch file text form
into the lp file named in the lp file text form.
.br
.sp
.I Auto
- perform automatically in order, LP, Pitch, Merge.
.PP
.SH Info Buttons
.PP
.I LP Dump
- display the analysis data in text form in a scrolling text window.
Text appearing in this window may be cut, copied, pasted, etc in the usual
manner.
.br
.sp
.I Soundfile
- bring up a panel which displays a summary of the current soundfile
.PP
.SH Status Display
.PP
This text window displays the status of the action currently in progress,
including any errors encountered.
.PP
.I Very useful information:
.sp
Sometimes, one might notice that the pitch analysis is taking quite a long
time, like, a few hours.  If you are unfortunate enough to have this happen
simply apply the very effective cntl-C sequence as ptrack sometimes likes to
stick on the last frame of the pitch analysis.
[I have yet to encounter this behaviour, but should it occur it
will have to be terminated with 'kill' (PMY)]
.PP
.SH AUTHORS
Paul Lansky at Princeton, modified for MIT Experimental Music Studio
(ems.media.mit.edu) by dwf, bv, and dll.
Adapted for NeXT by Pete Yadlowsky at the University of Virginia.



