#include <stdio.h>                                        /*    LPTRKFNS.C   */
#include "cs.h"
#include "lpc.h"

#define FREQS  50
#define NN     5
#define NP     6  /* NN+1 */
#define HWIN   50 /* MAXWINDIN/20, Max Hwind */

static float    ZERO = 0., ONE = 1., TWO = 2., TWOPI = 6.2831853;
static float	*tphi[FREQS],*tpsi[FREQS]; /* prv tphi[50][5][25],tpsi[50][6][25] */
static float	*tgamph[FREQS], *tgamps[FREQS], freq[FREQS];
          /* prv tgamph[50][5],  tgamps[50][6] */
static float    NYQ10, search(), lowpass();
static int 	Windsiz, Windsiz2;         /* settable windowsize, halfthat */
static int 	Dwind, Hwind;              /* settable downsamp10, halfthat */
static void     trigpo();

typedef float (*phi_typ)[HWIN];
typedef float (*psi_typ)[HWIN];

void ptable(fmin, fmax, esr, windsiz)
     float fmin, fmax, esr;
     int   windsiz;
{
	int   i, n;
	float omega, fstep, tpidsrd10;

	if (HWIN * 20 != MAXWINDIN)
	    die("LPTRKFNS: inconsistent MAXWindow defines");
	NYQ10   = esr/20.;
	Windsiz = windsiz;              /* current windin size */
	Windsiz2 = windsiz/2;           /* half of that        */
	Dwind   = windsiz/10;           /* downsampled windsiz */
	Hwind   = (Dwind+1)/2;          /* half of that        */
	if (Hwind > HWIN)
	    die("LPTRKFNS: called with excessive Windsiz");
	tpidsrd10 = TWOPI / (esr/10.);
	fstep = (fmax - fmin) / FREQS;    /* alloc & init each float array  */
	for (i=0 ; i<FREQS; ++i) {        /*   as if MAX dimension of Hwind */
	    tphi[i] = (float *) mcalloc((long)NN * HWIN * sizeof(float));
	    tpsi[i] = (float *) mcalloc((long)NP * HWIN * sizeof(float));
	    tgamph[i] = (float *) mcalloc((long)NN * sizeof(float));
	    tgamps[i] = (float *) mcalloc((long)NP * sizeof(float));
	    freq[i] = fmin + (float)i * fstep;
	    n = NYQ10 / freq[i];
	    if (n > NN)  n = NN;
	    omega = freq[i] * tpidsrd10;
	    trigpo(omega,(phi_typ)tphi[i],(psi_typ)tpsi[i],tgamph[i],tgamps[i],n);
	}
}

static void trigpo(omega, phi, psi, gamphi, gampsi, n)
     float omega, phi[NN][HWIN], psi[NP][HWIN], gamphi[NN], gampsi[NP];
     int n;
{
	int    j=0, k, np;
	double alpha, beta, gamma, wcos[HWIN], wsin[HWIN];
	double p, z, a, b, yy, sin(), cos();

	np = n+1;
	for (k=0 ; k<Hwind ; ++k) {
	    yy = omega * (float)k;
	    wcos[k] = cos(yy);
	    wsin[k] = sin(yy);
	}
	beta = gamma = ZERO;
	for (k=0 ; k<Hwind ; ++k) {
	    p = wsin[k];
	    z = p * p;
	    beta += z * wcos[k];
	    gamma += z;
	    phi[0][k] = p;
	}
	gamphi[0] = gamma;
	a = TWO * beta/gamma;
	alpha = beta = gamma = ZERO;
	for (k=0 ; k<Hwind ; ++k) {
	    p = (TWO * wcos[k]-a) * phi[0][k];
	    alpha += wcos[k] * p * phi[0][k];
	    beta += wcos[k] * ( p * p ) ;
	    gamma +=  p * p ;
	    phi[1][k] = p ;
	}
	gamphi[1] = gamma;
	a = TWO * beta/gamma;
	b = TWO *alpha/gamphi[0];
	for (j=2 ; j<n ; ++j) {
	    alpha = beta = gamma = ZERO;
	    for (k=0 ; k< Hwind ; ++k)	{
		p = (TWO * wcos[k] - a ) * phi[j-1][k] - b * phi[j-2][k];
		alpha += wcos[k] * p * phi[j-1][k];
		beta += wcos[k] * (p * p);
		gamma += (p * p) ;
		phi[j][k] = p ;
	    }
	    gamphi[j] = gamma;
	    a = TWO * beta/gamma;
	    b = TWO *alpha/gamphi[j-1];
	}
	beta = ZERO ;
	gamma = (double) Hwind;
	for ( k=0; k < Hwind ; ++k) {
	    beta += wcos[k];
	    psi[0][k] = ONE;
	}
	gampsi[0] = gamma;
	a = beta/gamma;
	alpha = beta = gamma = ZERO;
	for ( k=0 ; k < Hwind ; ++k) {
	    p = wcos[k]-a;
	    alpha += wcos[k] * p*psi[0][k];
	    beta += wcos[k] * ( p * p );
	    gamma += (p * p);
	    psi[1][k] = p ;
	}
	gampsi[1] = gamma ;
	a = TWO * beta / gamma ;
	b = TWO * alpha / gampsi[0];
	for (j=2 ; j<np ;++j) {
	    alpha = beta = gamma = ZERO;
	    for (k=0; k < Hwind ; ++k) {
		p = (TWO * wcos[k]-a)* psi[j-1][k]-b*psi[j-2][k];
		alpha += wcos[k]*p*psi[j-1][k];
		beta += wcos[k]* (p*p);
		gamma += (p*p);
		psi[j][k] = p;
	    }
	    gampsi[j] = gamma;
	    a = TWO * beta/gamma;
	    b = TWO * alpha/gampsi[j-1];
	}
}

float getpch(sigbuf)
     float *sigbuf;
{
static  int   firstcall = 1, tencount = 0;
static  float *Dwind_dbuf, *Dwind_end1;    /* double buffer for downsamps   */
static  float *dbp1, *dbp2;
	float g[HWIN], h[HWIN], fm, qsum, y, *inp;
	int   n;

        if (firstcall) {                   /* on first call, alloc dbl dbuf  */
	    Dwind_dbuf = (float *) mcalloc((long)Dwind * 2 * sizeof(float));
	    Dwind_end1 = Dwind_dbuf + Dwind;
	    dbp1 = Dwind_dbuf;             /*   init the local Dsamp pntrs */
	    dbp2 = Dwind_end1;             /*   & process the whole inbuf  */
	    for (inp = sigbuf, n = Windsiz; n--; ) {
	        y = lowpass(*inp++);            /* lowpass every sample  */
		if (++tencount == 10) {
		    tencount = 0;
		    *dbp1++ = y;                /*    & save every 10th  */
		    *dbp2++ = y;
		    if (dbp1 >= Dwind_end1) {
		        dbp1 = Dwind_dbuf;
			dbp2 = Dwind_end1;
		    }
		}
	    }
	    firstcall = 0;
	}
        else {                           /* other calls: process only inbuf2  */
	    for (inp = sigbuf+Windsiz2, n = Windsiz2; n--; ) {
	        y = lowpass(*inp++);            /* lowpass every sample  */
		if (++tencount == 10) {
		    tencount = 0;
		    *dbp1++ = y;                /*    & save every 10th  */
		    *dbp2++ = y;
		    if (dbp1 >= Dwind_end1) {
		        dbp1 = Dwind_dbuf;
			dbp2 = Dwind_end1;
		    }
		}
	    }
	}
        {
	    register float *gp, *hp, *sp1, *sp2;
	    qsum = ZERO;
	    gp = g; hp = h;
	    sp1 = sp2 = dbp1 + Hwind - 1;
	    for (n = Hwind; n--; gp++, hp++, sp1++, sp2-- ) {
	        *gp = .5 * (*sp1 - *sp2);        /* get sum & diff pairs */
		*hp = .5 * (*sp1 + *sp2);
		qsum += *gp * *gp + *hp * *hp;   /* accum sum of squares */
	    }
	}
	return ( search(&fm, qsum, g, h) );
}

static float search(fm, qsum, g, h)
     float *fm, qsum, g[], h[];
{
	float fun[FREQS], funmin = 1.e10;
	float sum, f1, f2, f3, x0, x1, x2, x3, a, b, c, ftemp;
	int   i, istar = 0, n, np, j, k;

        for (i=0 ; i < FREQS ; ++i) {
	    register float (*tphii)[HWIN], (*tpsii)[HWIN];
	    register float  *tgamphi, *tgampsi;
	    tphii = (float (*)[HWIN]) tphi[i];    /* dim [][NN][HWIN] */
	    tpsii = (float (*)[HWIN]) tpsi[i];    /* dim [][NP][HWIN] */
	    tgamphi = tgamph[i];                  /* dim [][NN]       */
	    tgampsi = tgamps[i];                  /* dim [][NP]       */
	    n = NYQ10 / freq[i];
	    if (n > NN)  n = NN;
	    np = n+1;
	    sum = ZERO;
	    for (j=0 ; j < n ; ++j) {
		c = ZERO;
		for (k=0 ; k< Hwind ; ++k)  
		    c += g[k] * tphii[j][k];
		sum += (c*c) / tgamphi[j];
	    }
	    for (j=0 ; j<np ; ++j) {
		c = ZERO;
		for (k=0 ; k < Hwind ; ++k) 
		    c += h[k] * tpsii[j][k];
		sum += (c*c) / tgampsi[j];
	    }
	    fun[i] = ftemp = qsum - sum;      /* store the least sqr vals */
/*    printf("qsum %f  sum %f  ftemp %f\n", qsum, sum, ftemp);   */
	    if (ftemp < funmin) {
		funmin = ftemp;               /*   but remember minimum   */
		istar = i;
	    }
	}
	if (istar == 0 || istar == 49) {
	    *fm = fun[istar];
	    return (freq[istar]);
	}
	x1 = freq[istar-1];
	f1 = fun[istar-1];
	x2 = freq[istar];
	f2 = fun[istar];
	x3 = freq[istar+1];
	f3 = fun[istar+1];
	a = f3/((x3-x1)*(x3-x2));
	b = f2/((x2-x1)*(x2-x3));
	c = f1/((x1-x2)*(x1-x3));
	x0 = .5*(a*(x1+x2)+b*(x1+x3)+c*(x2+x3))/(a+b+c);
	*fm = a*(x0-x1)*(x0-x2)+b*(x0-x1)*(x0-x3)+c*(x0-x2)*(x0-x3);
	return (x0);
}

static float lowpass(x)
     float x;		/* now float */
{
static	float c = .00048175311;
static	float a1 = -1.89919924, c1 = -1.92324804, d1 = .985720370;
static	float a2 = -1.86607670, c2 = -1.90075003, d2 = .948444690;
static	float a3 = -1.66423461, c3 = -1.87516686, d3 = .896241023;
static	float c4 = -.930449120;
static  float w1 = 0., w11 = 0., w12 = 0.;
static	float w2 = 0., w21 = 0., w22 = 0.;
static  float w3 = 0., w31 = 0., w32 = 0.;
static	float w4 = 0., w41 = 0., w42 = 0.;
        float temp,y;
	
	w1 = c*x - c1*w11 - d1*w12;
	temp = w1 + a1*w11 + w12;
	w12 = w11;
	w11 = w1;
	w2 = temp - c2*w21 - d2*w22;
	temp = w2 + a2*w21 + w22;
	w22 = w21;
	w21 = w2;
	w3 = temp - c3*w31 - d3*w32;
	temp = w3 + a3*w31 + w32;
	w32 = w31;
	w31 = w3;
	w4 = temp - c4*w41;
	y = w4 + w41;
	w42 = w41;   /* w42 set but not used in lowpass */
	w41 = w4;
	return(y);
}

