/*  gammon.h

    Copyright (C) 1994	Lambert Klasen & Detlef Steuer
			klasen@asterix.uni-muenster.de
			steuer@amadeus.statistik.uni-dortmund.de

    This file is free source code; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
    COPYING for more details.
 */


/* whose turn it is */
#define BLACK 1
#define WHITE 2

/* kind of game */
#define COMPI_VS_COMPI 0
#define HUMAN_VS_COMPI 1
#define HUMAN_VS_HUMAN 2

/* players */
#define COMPUTER 1
#define HUMAN 2

/* doubler routine flags (decision.c doubler()) */
#define ANSWER 1
#define OFFER 2

/* special board areas */
#define BAR start_pin
#define OTHER_BAR end_pin
#define FINISHED (25+turn)
#define DOUBLER 30

/* "flags" */
#define NORMAL_GAME 0
#define FINISH_GAME 1
#define ROLLOUT 2
#define EDITED_POSITION 3
#define LOADED_POSITION 4
#define COMPUTER_TOURNAMENT 5


int	turn, other, pash, to_move, roll[4];
int	direction, start_pin, end_pin;
int	doubler_value, last_doubler;

struct _Player {
	int beginner_of_game;
	int type;			/* human or compi */
	int color;
}Player[2];

struct  _PinTable {
        int count;
        int color;
} Pin[29], rollout_position[29];	/* 0 - 25 -> 0, 25 = bar, 1 - 24 = board and 26, 27 finished[color] */


/* if you have the dice values 1 and 1 and all stones are on different
   pin and all completely movable there are almost 2000 possibilities to 
   move your stones, and sice a move contains 4 single steps ...

   this following list is sturctured in parts of four single moves
   not concerning if the dice are equal */

struct _Move {
        int from;
        int to;
} possible_moves[8000], *list;

int gammons[2], backgammons[2];			/* count them */

struct _Tournament {
	unsigned int   game_number;
	unsigned int   points[3];		/* dummy, BLACK, WHITE */
	unsigned int   winning_point;
} tournament;

struct _RolloutSave {
	int turn;
	int doubler_value;
	int last_doubler;
	int roll[2];
} rollout_save;

#define DATABASE "lib/xgammon.db"
FILE *endgame_database;
