/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _DECK
#define _DECK

#include "types.h"

typedef struct _Deck
{	
  Int32  iCardsLeft;
  Int32  iCardsReturned;
  Int32  iTotalCards;
  Int32 *piCards;
  Int32 *piCardsReturned;
} Deck;

Deck   *DECK_Create(Int32 iNumCards);
Int32   DECK_GetCard(Deck *pDeck);
void    DECK_PutCard(Deck *pDeck, Int32 iCard);
void    DECK_Destroy(Deck *pDeck); 

#endif
