/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _CARDS
#define _CARDS

#include "types.h"
#include <X11/Xlib.h>

#define CARD_WIDTH  138
#define CARD_HEIGHT 190

void    CARD_RenderCard(Int32 iCard, Int32 iPositions);
XImage *CARD_ScaleImage(XImage *pimageInput, Int32 iMaxWidth, 
			Int32 iMaxHeight);

/* This is the mapping from (card #) :==> (country, type) where country
 * is the country to portray on the card, and type is defined in risk.h,
 * as CARD_[FOOTMAN|HORSEMAN|CANNON|JOKER]:
 *
 * The first 42 cards are: Card i is of country i and of type (i mod 3).
 * The next 2 cards are jokers.
 */

#endif
