/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>

#include "types.h"
#include "help.h"
#include "network.h"
#include "client.h"
#include "gui.h"
#include "callbacks.h"
#include "utils.h"
#include "debug.h"

String   *pstrIndexStrings;
String   *pstrHelpStrings;
String    strHelpFile;

Int iNumHelpTopics=0;

/* The first is the default number of topics, and the latter is the 
 * number of new topics to allocate if we run out room.
 */

#define HELP_TOPICS      32
#define HELP_MORETOPICS  8

/************************************************************************ 
 *  FUNCTION: HELP_Init
 *  HISTORY: 
 *     04.01.94  ESF  Created 
 *     04.02.94  ESF  Added allocation of more memory if needed.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void HELP_Init(String strHelpFile)
{
  FILE             *hHelpFile;
  struct stat       statBuf;
  char             *pHelpText;
  Int               i, j, iTopicsMemory = HELP_TOPICS;

  /* Allocate the default amount of room for the help topics */
  pstrIndexStrings = (String *)MEM_Alloc(sizeof(String)*iTopicsMemory);
  pstrHelpStrings = (String *)MEM_Alloc(sizeof(String)*iTopicsMemory);

  /* Open the file, and find out its size to allocate memory for it */
  if ((hHelpFile=fopen(HELPFILE, "r"))==NULL)
    {
      sprintf(strScratch, "HELP: cannot open %s!", HELPFILE);
      UTIL_PopupDialog("Fatal Error", strScratch, 1, "Ok", NULL, NULL);
      NET_SendMessage(iWriteSocket, MSG_EXIT, NULL);
      UTIL_ExitProgram(-1);
    }
  
  if (stat(strHelpFile, &statBuf)!=0)
    {
      UTIL_PopupDialog("Fatal Error", "HELP: Couldn't get size of file", 
		       1, "Ok", NULL, NULL);
      NET_SendMessage(iWriteSocket, MSG_EXIT, NULL);
      UTIL_ExitProgram(-1);
    }

  /* Read in the file after allocating room for it */
  pHelpText = strHelpFile = (String)MEM_Alloc(statBuf.st_size);
  fread(strHelpFile, statBuf.st_size, 1, hHelpFile);

  /* Search through the file for topics, filling out the tables of topic
   * pointers as we go, and allocating more memory as needed.  When we
   * find an end of topic, stick a '\0' in, and erase '\n' since the
   * text widget will do the word wrapping for us.  This can be sped up!
   */

  for (i=0; i!=statBuf.st_size; i++)
    {
      if (pHelpText[i] == '\n' && 
	  (pHelpText[i+1] == '\n' || pHelpText[i+1] == '\t')) 
	  i++;
      else if (pHelpText[i] == '\n')
	pHelpText[i] = ' ';
      else if (pHelpText[i] == '%' && pHelpText[i+1] == '%')
	{
	  /* We've found the end of a topic */
	  pHelpText[i] = '\0';
	  i+=2;
	}
      else if (pHelpText[i] == '%')
	{
	  /* We've found the beginning of a topic */
	  pstrIndexStrings[iNumHelpTopics] = &pHelpText[i+1];

	  /* Find the beginning of the topic */
	  for (j=i; pHelpText[j]!='\n'; j++)
	    ; /* TwiddleThumbs() */

	  pHelpText[j] = '\0';
	  pstrHelpStrings[iNumHelpTopics++] = &pHelpText[j+1];

	  /* Allocate more memory? */
	  if (iNumHelpTopics > iTopicsMemory)
	    {
	      iTopicsMemory += HELP_MORETOPICS;
	      pstrHelpStrings = (String *)realloc(pstrHelpStrings, 
						  sizeof(String)*
						  iTopicsMemory);
	      pstrIndexStrings = (String *)realloc(pstrIndexStrings, 
						   sizeof(String)*
						   iTopicsMemory);
	    }
	}
    }
	
  /* Put the index strings in the list widget */
  XtVaSetValues(wHelpTopicList, 
		XtNlist, pstrIndexStrings, 
		XtNnumberStrings, iNumHelpTopics, 
		NULL);
}


/************************************************************************ 
 *  FUNCTION: 
 *  HISTORY: 
 *     04.01.94  ESF  Created 
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void HELP_IndexPopupHelp(Int iTopic)
{
  if (iTopic<0 || iTopic>=iNumHelpTopics)
    {
      UTIL_PopupDialog("Warning", "HELP: Topic not available!", 
		       1, "Ok", NULL, NULL);
      return;
    }

  XtVaSetValues(wHelpLabel, 
		XtNlabel, pstrIndexStrings[iTopic],
		NULL);
  XtVaSetValues(wHelpText, 
		XtNstring, pstrHelpStrings[iTopic],
		NULL);
}


/************************************************************************ 
 *  FUNCTION: 
 *  HISTORY: 
 *     04.01.94  ESF  Created 
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void HELP_StringPopupHelp(String strTopic)
{

}

