/* C++ wrapper for assembler block copy routines */

#ifndef BLOCK_H
#define BLOCK_H

extern "C"{
#include "btypes.h"
#include <vga.h>
}

class
Block
{
protected:
	byte *blockmem;
	uint32 width,height,Bytelength;
	static byte* gmem;
public:
	Block() { if(gmem==0) gmem=vga_getgraphmem(); }
	~Block() { if (blockmem!=0) delete blockmem; }

	void Cut(uint32 x1, uint32 y1, uint32 xw, uint32 yw);
	void Recut(uint32 x1, uint32 y1);
	void Paste(uint32 x1, uint32 y1);
        int getHeight(void) const { return height;}
        int getWidth(void) const { return width;}

        void setGraphMem( byte *gptr) { gmem=gptr; }
};

#endif
