// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// Classes: Sprite

#ifndef __Sprite__
#define __Sprite__

#include <stdlib.h>
#include <math.h>
#include <vgagl.h>

#include "Bitmap.h"
#include "ObjTools.h"
#include "Explosion.h"
#include "FastMath.h"

//////////////////////////////////////////////////////////////////////////////
// Note: bitmaps should be square: width=height
// Objects drawn in bitmap should be approx. round
// since the collision detection method used in this prog is
// pretty simple/dumb.  

class Sprite : public Life, public Trajectory {
    public:
    
    	Sprite( int sh, double m, const Bitmap& b) : 
    		shape(sh), mass(m), Vsize(0), Life(), Trajectory()
    		{
    		setBitmap(b);
    		};

    	inline virtual void draw()
    		{
		Vbitmap->put( FP2INT(VFx)-Vsize, FP2INT(VFy)-Vsize );
    		}


	// do the stuff that should happen in one 'frame' of time, i.e.
	// move the obj, etc..
    	inline virtual void tick()		
    		{	
		Life::tick();

		Trajectory::move();
		}

	inline void explode(int size, int dur)
		{
		// add an explosion to the explosion list
		Boom::add( VFx, VFy, size, dur, VFxvel, VFyvel );
		}

	void setBitmap( const Bitmap &b ) 
		{ 
		Vbitmap=&b; 
		Vsize = b.width() >> 1;
		// size is 1/2 of the width of the *square* bitmap.
		}

	//Bitmap& bitmap() { return b; }
	
	inline int	size() const { return Vsize; }

	inline void	towards( const Sprite& b, FixedPoint Fspeed )
			{ Trajectory::towards( b.VFx, b.VFy, Fspeed ); }

	friend int	distance( const Sprite& b1, const Sprite& b2 );

	// determine if 2 Sprites have collided
	friend int collide(const Sprite& b1, const Sprite& b2);


    	int shape;
	Angle Vangle;	// Angles from 0-255, not 0-359
	double mass;

	
    private:
	const Bitmap *Vbitmap;
	int		Vsize;
     };


// *Friend Function*
// Needs to be optimized to remove sqrt() call.
inline int	distance( const Sprite& b1, const Sprite& b2 )
	{ 
	FixedPoint Fdx= b1.VFx - b2.VFx;
	FixedPoint Fdy= b1.VFy - b2.VFy;
	return (int) sqrt( FP2INT(FPMULT(Fdx,Fdx) + FPMULT(Fdy,Fdy)) );
 	}

#endif
