/*
 * Imperium
 *
 * Copyright (C) 1990-1993 by David Wright
 *
 * $Id: Server.h,v 3.4.1.2 1994/02/10 04:40:46 davewt Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: Server.h,v $
 * Revision 3.4.1.2  1994/02/10  04:40:46  davewt
 * patch16: DEBUG_SERV is now an #ifdef in Server.h
 *
 * Revision 3.4.1.1  1993/11/19  06:26:24  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:04:31  davewt
 * New revision.
 *
 * Revision 3.2  1993/10/07  02:10:21  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:56:19  davewt
 * patch1: First patch to initial version.
 *
 * Revision 1.1  1993/08/23  23:19:59  davewt
 * Initial revision
 *
 * 
 */

/*
 * Server.h - include file for Imperium server - define function prototypes
 */

/* FileIO.c */

void log(char *);
void logN(char *, ULONG, char *);
void myAbort(char *);
void closeFiles(void);
void openFiles(char *, char *, char *);
BOOL readWorld(World_t *, Player_t *);
void writeWorld(World_t *, Player_t *);
void readSector(USHORT, Sector_t *);
void writeSector(USHORT, Sector_t *);
void readShip(ULONG, Ship_t *);
void writeShip(Ship_t *);
void readFleet(USHORT, Fleet_t *);
void writeFleet(USHORT, Fleet_t *);
void readLoan(USHORT, Loan_t *);
void writeLoan(USHORT, Loan_t *);
void readOffer(USHORT, Offer_t *);
void writeOffer(USHORT, Offer_t *);
void readPlanet(ULONG, Planet_t *);
void writePlanet(Planet_t *);
void readBigItem(ULONG, BigItem_t *);
void writeBigItem(BigItem_t *);

#ifdef DEBUG_SERV
#define DEBUG_SHIP      0x1
#define DEBUG_PLANET    0x2
#define DEBUG_BIGITEM   0x4
#endif

