case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Servers/Makefile (with variable substitutions)"
$spitshell >Makefile <<!GROK!THIS!
# makefile for Imperium servers
# (C) 1990-94 by David Wright

IMP_DEST = $installprivlib
IMP_OWN = $impown
IMP_GRP = $impgrp
IMP_BR = $baserev

CC = $cc
CFLAGS = $warnflags -DBROKEN_PIPE -DBROKEN_MKNOD $ccflags
DEBUG = $optimize $servdebug
LDFLAGS = $ldflags

RM = $rm -f
ETAGS = $etags
SH = $sh

# Imperium link targets
IMPLIB = $implinklib
LIB_TARG = $implinktarg
CRYPTLIB = $cryptlib

!GROK!THIS!

case "$installpgm" in
ninstall)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = ../$fullinstallpgm
!GROK!THIS!
;;
*)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = $fullinstallpgm
!GROK!THIS!
;;
esac

$spitshell >>Makefile <<'!NO!SUBS!'
IMPINC = ../Include/Imperium.h
SERVINC = Server.h
CONFINC = ../config.h
SERVOBJ = ServerMain.o FileIO.o

INCFILES = $(IMPINC)
ALLFLAGS = $(DEBUG) $(CFLAGS) -DFIFO_DIR="\"$(IMP_DEST)/fifo\"" -DIMP_BASE_REV="\"$(IMP_BR)\""

.c.o:
	@echo "Working on $*.c"
	@$(CC) $(ALLFLAGS) -c -o $*.o $<

all:    ImpServ ImpShut ImpCtrl ic.allow is.allow

ServerMain.o: ServerMain.c $(INCFILES) $(SERVINC) ../Include/Request.h $(CONFINC) ../patchlevel.h ../impsec.h

FileIO.o: FileIO.c $(INCFILES) $(SERVINC) $(CONFINC)

ImpServ: $(SERVOBJ)
	@echo "Linking ImpServ"
	@$(CC) $(LDFLAGS) -o ImpServ $(SERVOBJ) $(CRYPTLIB)

ImpShut.o: ImpShut.c $(INCFILES) ../Include/Request.h $(CONFINC) ../patchlevel.h ../impsec.h

ImpShut: ImpShut.o
	@echo "Linking ImpShut"
	@$(CC) $(LDFLAGS) -o ImpShut ImpShut.o $(CRYPTLIB)

ImpCtrl: ImpCtrl.o $(IMPLIB)
	@echo "Linking ImpCtrl"
	@$(CC) $(LDFLAGS) -o ImpCtrl ImpCtrl.o $(IMPLIB) -lc $(CRYPTLIB)

ic.allow: ic.allow.SH ../config.sh
	@$(SH) ic.allow.SH

is.allow: is.allow.SH ../config.sh
	@$(SH) is.allow.SH

$(IMPLIB):
	cd ../Library;./doMake $(LIB_TARG)

ImpCtrl.o: ImpCtrl.c $(INCFILES) ImpCtrl.h $(CONFINC) ../Include/Request.h ../Include/ImpLib.h ../patchlevel.h ../impsec.h

../impsec.h:
	cd ..;./gSCodes

archive:
	makearchive

TAGS:
	$(ETAGS) -t *.c *.h ../Include/*.h

clean:
	-$(RM) ImpCtrl ImpShut ImpServ *.o

install: ImpCtrl ImpShut ImpServ
	$(INSTALL) -d -g $(IMP_GRP) -m 755 -o $(IMP_OWN) $(IMP_DEST)/servers
	$(INSTALL) -g $(IMP_GRP) -m 711 -o $(IMP_OWN) ImpCtrl $(IMP_DEST)/servers
	$(INSTALL) -g $(IMP_GRP) -m 711 -o $(IMP_OWN) ImpShut $(IMP_DEST)/servers
	$(INSTALL) -g $(IMP_GRP) -m 4700 -o $(IMP_OWN) ImpServ $(IMP_DEST)/servers
	$(INSTALL) -g $(IMP_GRP) -m 644 -o $(IMP_OWN) ic.allow $(IMP_DEST)
	$(INSTALL) -g $(IMP_GRP) -m 644 -o $(IMP_OWN) is.allow $(IMP_DEST)

!NO!SUBS!
chmod 644 Makefile
$eunicefix Makefile
