case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Library/Makefile (with variable substitutions)"
$spitshell >Makefile <<!GROK!THIS!
# Makefile for Imperium link library

IMP_DEST=$installprivlib
IMP_OWN=$impown
IMP_GRP=$impgrp

CC = $cc
CFLAGS = $warnflags $ccflags
DEBUG = $optimize $libdebug

DYNAMIC = $dynlinkcmd
DEFTARGET = $implinktarg
IMP_BR = $baserev

RM = $rm -f
ETAGS = $etags
LN = $ln -s
AR = $ar
RANLIB = $ranlib

!GROK!THIS!

case "$installpgm" in
ninstall)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = ../$fullinstallpgm
!GROK!THIS!
;;
*)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = $fullinstallpgm
!GROK!THIS!
;;
esac

$spitshell >>Makefile <<'!NO!SUBS!'

# This is the name of the output library
STATIMPLIB = libimpm.a

OBJFILES = messages.o util.o commands.o parse.o startup.o scan.o cmd_edit.o \
	cmd_user.o update.o cmd_general3.o cmd_general1.o cmd_map.o \
	cmd_general2.o cmd_naval.o cmd_move.o cmd_naval2.o cmd_verify.o \
	cmd_action.o cmd_trade.o cmd_telep.o feSupp.o cmd_fight.o

IMPINC = ../Include/Imperium.h
IMPREQINC = ../Include/Request.h
IMPFEMESS = ../Include/ImpFeMess.h
IMPPRIV = ImpPrivate.h
IMPSCANINC = Scan.h
IMPCOMBINC = Combat.h

# These are for dynamic linking, but you shouldn't need to touch them to
# use static linking either.
JUMP_LIB = libimpm
ADDRESS = 0x62b00000
JUMPSIZE = 0x1000
GOTSIZE = 0x0500
VER_MAJ = 0
VER_MIN = 5
VERSION = $(VER_MAJ).$(VER_MIN)
IMAGE = $(IMP_DEST)/lib/libimpm

ALLFLAGS = $(DEBUG) $(DYNAMIC) $(CFLAGS) -DIMP_BASE_REV="\"$(IMP_BR)\""

INCFILES = $(IMPINC) $(IMPREQINC) $(IMPPRIV) ../config.h

all: $(DEFTARGET)

.c.o:
	@echo "Working on $*.c"
	@$(CC) $(ALLFLAGS) -c -o $*.o $<

$(JUMP_LIB).so.$(VERSION): $(OBJFILES)
	@echo "Building the dynamic library"
	@/usr/dll/bin/mkimage -f -l $(IMAGE) -v $(VERSION) -a $(ADDRESS) -j $(JUMPSIZE) -g $(GOTSIZE) -- $(OBJFILES) -lgcc -lc

$(STATIMPLIB): $(OBJFILES) Makefile
	@echo "Building the static library"
!NO!SUBS!
case $ranlib in
':')
$spitshell >>Makefile <<'!NO!SUBS!'
	@$(AR) rs $(STATIMPLIB) $(OBJFILES)
!NO!SUBS!
;;
*)
$spitshell >>Makefile <<'!NO!SUBS!'
	@$(AR) r $(STATIMPLIB) $(OBJFILES)
	@$(RANLIB) $(STATIMPLIB)
!NO!SUBS!
;;
esac
$spitshell >>Makefile <<'!NO!SUBS!'

image:	$(JUMP_LIB).so.$(VERSION)

stubs:	libimpm.sa

libimpm.sa: $(JUMP_LIB).so.$(VERSION)
	@echo "Creating the dynamic library stub file"
	@/usr/dll/bin/mkstubs -l $(IMAGE) -v $(VERSION) -a $(ADDRESS) -j $(JUMPSIZE) -g $(GOTSIZE) -- libimpm
clean:
	-$(RM) $(OBJFILES) $(STATIMPLIB) *.so.$(VERSION) libimpm.sa

TAGS: $(OBJFILES) $(IMPHEAD)
	$(ETAGS) -t *.c *.h $(IMPINC) $(IMPREQINC) $(IMPPRIV) $(IMPFEMESS)

startup.o: startup.c $(INCFILES) ../Servers/ImpCtrl.h $(IMPFEMESS) ../patchlevel.h
util.o: util.c $(INCFILES)
commands.o: commands.c $(INCFILES)
parse.o: parse.c $(INCFILES)
messages.o: messages.c $(INCFILES)
scan.o: scan.c $(INCFILES) $(IMPSCANINC)
cmd_edit.o: cmd_edit.c $(INCFILES)
cmd_user.o: cmd_user.c $(INCFILES)
cmd_general3.o: cmd_general3.c $(INCFILES)
update.o: update.c $(INCFILES)
cmd_general1.o: cmd_general1.c $(INCFILES)
cmd_map.o: cmd_map.c $(INCFILES)
cmd_naval.o: cmd_naval.c $(INCFILES)
cmd_naval2.o: cmd_naval2.c $(INCFILES) $(IMPFEMESS)
cmd_general2.o: cmd_general2.c $(INCFILES)
cmd_move.o: cmd_move.c $(INCFILES)
cmd_fight.o: cmd_fight.c $(INCFILES) $(IMPCOMBINC)
cmd_trade.o: cmd_trade.c $(INCFILES)
cmd_verify.o: cmd_verify.c $(INCFILES)
cmd_action.o: cmd_action.c $(INCFILES) $(IMPFEMESS)
cmd_telep.o: cmd_telep.c $(INCFILES)
feSupp.o: feSupp.c $(INCFILES) $(IMPFEMESS)

!NO!SUBS!
case "$wantdynlib" in
'y')
$spitshell >>Makefile <<'!NO!SUBS!'
install:	$(JUMP_LIB).so.$(VERSION)
	$(INSTALL) -d -g $(IMP_GRP) -m 755 -o $(IMP_OWN) $(IMP_DEST)/lib
	$(INSTALL) -g $(IMP_GRP) -m 444 -o $(IMP_OWN) $(JUMP_LIB).so.$(VERSION) $(IMAGE).so.$(VERSION)
	-$(RM) $(IMAGE).so.$(VER_MAJ)
	$(LN) $(IMAGE).so.$(VERSION) $(IMAGE).so.$(VER_MAJ)
!NO!SUBS!
;;
*)
$spitshell >>Makefile <<'!NO!SUBS!'
install:
	@echo "No installation needed for static libs..."
!NO!SUBS!
;;
esac
chmod 644 Makefile
$eunicefix Makefile
