#include "misc.h"
#include "defs.h"
#include "client.h"
#include <malloc.h>

table_ptr	first_table,
		cur_table;

int		table_count = 0,	/* # tables existing */
		cur_screen_table,	/* nth table shown as table 1 */
		screen_table_id[8];	/* table_id of tables on screen */

char		joined, joining;


/*
 * Find table given unique table_id in buf[1].
 */
table_ptr
find_table(buf)
char	*buf;
{
	table_ptr	cur_table;
	int		table_num;

	(void) sscanf(buf + 1, "%d", &table_num);
	for (cur_table = first_table;
			cur_table && cur_table->table_id != table_num;
			cur_table = cur_table->next_table)
		;
	return(cur_table);
}

/*
 * Create new table given table_id in buf[1].  Return pointer to new table.
 */
table_ptr
new_table(buf)
char	*buf;
{
	table_ptr	cur_ptr, new_table_ptr;
	int		i, table_num;

	(void) sscanf(buf + 1, "%d", &table_num);
	new_table_ptr = (table_ptr) malloc(sizeof(struct table));
	new_table_ptr->next_table = NULL;
	new_table_ptr->table_id = table_num;
	new_table_ptr->closed = FALSE;
	new_table_ptr->data = NULL;
	for (i = 0; i < 4; i++)
		(void) strcpy(new_table_ptr->player_name[i], "<empty>");
	if (first_table) {
		for (cur_ptr = first_table; cur_ptr->next_table;
				cur_ptr = cur_ptr->next_table)
			;
		cur_ptr->next_table = new_table_ptr;
	}
	else
		first_table = new_table_ptr;
	++table_count;
	return(new_table_ptr);
}

/*
 * Update current table entry based on buf.  Return table # modified.
 */
update_table(buf)
char	*buf;
{
	int		i;
	table_ptr	tmp_table;

	switch (buf[0]) {
	case 't' :
		if ((cur_table = find_table(buf)) == NULL)
			cur_table = new_table(buf);
		break;
	case 'h' :
		(void) sscanf(buf + 1, "%d", &cur_table->hand);
		break;
	case 'r' :
		(void) sscanf(buf + 1, "%d", &cur_table->round);
		break;
	case 'p' :
		(void) strcpy(cur_table->player_name[buf[1] - '0'], buf + 2);
		break;
	case 'x' :
		if (tmp_table = find_table(buf)) {
			for (i = 0; i < 8; i++)
				if (screen_table_id[i] = tmp_table->table_id)
					screen_table_id[i] = 0;
			tmp_table->table_id = 0;
			tmp_table->closed = TRUE;
		}
	}
}

dist_died(i)
int i;
{
  if (i == 1)
	death("Distributor died!! 1");
  else if (i == 2)
	death("Distributor died!! 2");
  else if (i == 3)
	death("Distributor died!! 3");
  else if (i == 4)
	death("Distributor died!! 4");
}

select_game()
{
	int	dealer_port;
	table_ptr	temp_table;
	char buf[64], another;

	option_init();
	/*
	 * Get current games info
	 */
	do {
		if (read_socket(dist_socket, buf) == 0)
			dist_died(1);
		if (buf[0] != 'g')
			update_table(buf);
	}
	while (buf[0] != 'g');

	show_tables(cur_screen_table = 1);

	/*
	 * Wait for user input or table update info
	 */
	joined = joining = FALSE;

	do {
	  option_scan(&another);
	}
	while (!joined);

	/*
	 * Now free up malloced table space
	 */
	option_clear();
	while (first_table) {
		temp_table = first_table;
		first_table = first_table->next_table;
		free ((char *) temp_table);
	}
	table_count = 0;
	option_init();

	if (!first_game && another)
		/*
		 * Play another game with current dealer.
		 */
		dealer_port = 0;
	else {
		if (read_socket(dist_socket, buf) == 0)
			dist_died(4);
		(void) sscanf(buf + 1, "%d", &dealer_port);
	}
	(void) close(dist_socket);
	close_socket(dist_socket);
	return(dealer_port);
}
