#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <netdb.h>

#ifndef NULL
#define NULL 0
#endif

#define INSTRUCT "hearts.instr"
#define HEARTSD "heartsd"
#define HEARTS_DIST "hearts_dist"

#define	SLEN	40		/* short string */
#define	PROTO	"tcp"		/* protocol */
#define	SERVICE	"hearts"	/* official service name */

#ifdef	FD_SETSIZE

#define WIDTH FD_SETSIZE
typedef	fd_set	fd_type;

#define fd_init(sock, fds) FD_ZERO(fds); FD_SET(sock, fds)
#define fd_set(sock, fds)  FD_SET(sock, fds)
#define fd_zero(fds) FD_ZERO(fds)
#define fd_isset(sock, fds)  (sock >=0 && FD_ISSET(sock, &fds))

#else

#define WIDTH 32
typedef	int	fd_type;

#define fd_init(sock, fds) *fds = 1 << sock
#define fd_set(sock, fds)  *fds |= 1 << sock
#define fd_zero(sock, fds) *fds = 0
#define fd_isset(sock, fds)  (sock >=0 && fds & (1 << sock))

#endif
