#ifndef _ARGUMENTS
#if defined(FUNCPROTO) || defined(__STD__) || defined(__cplusplus) || defined(c_plusplus)
#define _ARGUMENTS(arglist) arglist
#else
#define _ARGUMENTS(arglist) ()
#endif
#endif

/* Shared types */

typedef struct table *table_ptr;

struct table {
	table_ptr next_table;		/* Points to next table entry */
	int	table_id;		/* Unique ID from distributor */
	char	player_name[4][9];	/* Player names */
	int	hand;			/* Current table hand */
	int	round;			/* Current table round */
	char	closed;			/* If game over */
	char	*data;			/* display-specific data */
};

/* Calls to display client (e.g. curses or X11) */

extern int init _ARGUMENTS((int *, char **));
extern int scan();
extern int start_game();
extern int check_dealer();
extern int enter_card _ARGUMENTS((int, int));
extern int remove_card _ARGUMENTS((int, int));
extern int erase_window _ARGUMENTS((int));
extern int read_card();
extern int play_card _ARGUMENTS((int, int, int, char *));
extern int score_points _ARGUMENTS((int, int, int, char *));
extern int display_message _ARGUMENTS((int, char *));
extern int game_is_over();
extern int terminate();
extern int show_table _ARGUMENTS((table_ptr, int));
extern int show_tables _ARGUMENTS((int));
extern int option_scan _ARGUMENTS((char *));
extern int option_init();
extern int init_socket();
extern int close_socket _ARGUMENTS((int));
extern int option_clear();

/* Calls from display client */

extern int do_socket();
extern int read_from_socket _ARGUMENTS((char *));
extern int send_message _ARGUMENTS((char *));
extern int send_private_message _ARGUMENTS((int, char *));
extern int toggle_private_messages();
extern int send_card _ARGUMENTS((int, int));
extern int send_auto();
extern int dist_died _ARGUMENTS((int));
extern int wimp_out();
extern int get_rank _ARGUMENTS((int));
extern int get_suit _ARGUMENTS((int));
extern int start_new_game();
extern int join_game _ARGUMENTS((int));
extern int do_dist();

/* Shared variables */
extern int dist_socket, dealer_socket;
extern char first_game, joined, joining;
extern table_ptr first_table, cur_table;
extern int table_count, cur_screen_table, screen_table_id[8];
extern char *snames[], rnames[];
