/* $Id: malloc.h,v 30000.1 1993/05/18 09:05:35 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef MALLOC_H
#define MALLOC_H

#ifdef DMALLOC
#define MALLOC(size) dmalloc((size), __FILE__, __LINE__)
#define REALLOC(ptr, size) drealloc((ptr), (size), __FILE__, __LINE__)
#define FREE(ptr) dfree((char*)(ptr), __FILE__, __LINE__)
#else
#define MALLOC(size) dmalloc((size))
#define REALLOC(ptr, size) drealloc((ptr), (size))
#define FREE(ptr) free((char*)(ptr))
#endif

#ifdef DMALLOC
extern char  *FDECL(dmalloc,(long unsigned size, CONST char *file, CONST int line));
extern char  *FDECL(drealloc,(char *ptr, long unsigned size, CONST char *file, CONST int line));
extern void   FDECL(dfree,(char *ptr, CONST char *file, CONST int line));
#else
extern char  *FDECL(dmalloc,(long unsigned size));
extern char  *FDECL(drealloc,(char *ptr, long unsigned size));
#endif

#endif /* MALLOC_H */
