/* $Id: fd_set.h,v 30000.20 1993/05/04 22:38:49 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef FD_SET_H
#define FD_SET_H

#ifndef FD_ZERO
/* For BSD 4.2 systems. */
/* Assuming ints are 32 bits, this allows 32 open sockets.  That's plenty. */
# define fd_set int
# define FD_SET(n, p) (*p |= (1<<(n)))
# define FD_CLR(n, p) (*p &= ~(1<<(n)))
# define FD_ISSET(n, p) (*p & (1<<(n)))
# define FD_ZERO(p) (*p = 0)
#endif /* End of BSD 4.2 systems. */

#endif /* FD_SET_H */
