/* externs.h */

/* Patched 12/1/90 by Michael Stanley (jstanley@uafhp.uark.edu) to 
 * add @search command.  details in file game.c                    
 * Patched 1/3/91 by Stan Lim aka Jin (stanl@zimmer.csufresno.edu) to add
 * do_hide and do_unhide.
 * Patched numerous times by Moonchilde (jt1o@andrew.cmu.edu) between
 * 1/91 and 11/91.
 * Patched numerous times by Amberyl (lwl@eniac.seas.upenn.edu) after
 * 1/92.
 */

#ifndef __EXTERNS_H
#define __EXTERNS_H

#include "copyright.h"
#include "config.h"

/* Prototypes for externs not defined elsewhere */
#include "db.h"
#include "attrib.h"

/* From attrib.c */
extern ATTR *atr_str();
extern ATTR *atr_complete_match();
extern struct boolatr *alloc_atr();
extern void atr_clr();
extern ALIST *AL_MAKE();
extern int atr_add();
extern ATTR *atr_get();
extern ATTR *atr_get_noparent();
extern void free_attrib();
extern void atr_free();
extern void atr_collect();
extern void atr_cpy();
extern void do_atrlock();
extern void do_atrchown();
extern const char *convert_atr();
extern ATTR *atr_match();
extern int atr_comm_match();

/* From bsd.c */
extern FILE *connlog_fp;
extern FILE *checklog_fp;
extern FILE *wizlog_fp;
extern FILE *tracelog_fp;
extern FILE *cmdlog_fp;

/* From compress.c */
extern const char *compress();
extern const char *uncompress();
extern char *safe_uncompress();

/* From cque.c */
extern void do_second();
extern int do_top();
extern void do_halt();
extern void parse_que();

/* From create.c */
extern dbref do_dig();
extern dbref do_create();

/* From flags.c */
extern const char *unparse_flags();
#ifdef FLAGS_ON_EXAMINE
extern const char *flag_description();
#endif
extern object_flag_type find_flag();
extern object_flag_type letter_to_flag();

/* From game.c */
#define notify(p,m)           notify_check(p,m,0)
#define notify_noecho(p,m)    notify_check(p,m,1)
#define quiet_notify(p,m)     if (!IsQuiet(p)) notify_check(p,m,0)
extern void notify_check();
extern void report();
extern int Hearer();
extern int Commer();
extern int Listener();

/* From log.c */
extern void start_log();
extern void end_log();
extern void do_log();

/* From look.c */
extern void look_room();
extern void do_look_around();
extern void do_look_at();

#ifdef USE_MAILER
/* From mail.c */
extern struct mail *maildb;
extern void clear_mail();
extern int dump_mail();
extern int load_mail();
extern void mail_init();
extern int mdb_top;
#endif				/* USE_MAILER */

/* From move.c */
extern void enter_room();
extern void send_home();
extern int can_move();
extern void do_move();
extern void moveto();
extern void safe_tel();
#ifdef DO_GLOBALS
extern dbref global_exit();
extern dbref remote_exit();
#endif
extern void move_wrapper();

/* From player.c */
extern int password_check();
extern dbref lookup_player();

/* From predicates.c */
extern char *tprintf();
extern int could_doit();
extern void did_it();
extern int can_see();
extern int controls();
extern int can_pay_fees();
extern void giveto();
extern int payfor();
extern int nearby();
extern object_flag_type find_flag();
#ifdef QUOTA
extern int get_current_quota();
extern void change_quota();
extern int pay_quota();
#endif
extern int ok_name();
extern int ok_player_name();
extern int ok_password();
extern dbref parse_match_possessive();
extern void page_return();
extern char *grep_util();

#ifdef ALLOW_RPAGE
/* From rpage.c */
extern void dump_server_database();
extern void rpage_init();
extern void rpage_shutdown();
extern void recv_rpage();
#endif				/* ALLOW_RPAGE */

/* From set.c */
extern void do_edit();

/* From speech.c */
extern void notify_except();
extern void notify_except2();

/* From stringutil.c */

#ifdef NEVER
extern int strcasecmp();
#endif				/* NEVER */

extern int string_prefix();
extern const char *string_match();
extern char *strupper();
extern char *upcasestr();
extern char *skip_space();
extern char *seek_char();
#ifndef SUN_OS
extern char *strdup();
#endif				/* SUN_OS */
extern int safe_chr();
extern int safe_str_copy();
extern char *replace_string();

#define safe_str(s,b,p)         safe_copy_str(s,b,p,BUFFER_LEN - 1)
#define safe_short_str(s,b,p)   safe_copy_str(s,b,p,SBUF_LEN - 1)

/* From utils.c */
extern void parse_attrib();
extern int member();
extern int recursive_member();
extern dbref remove_first();
extern dbref reverse();
extern struct dblist *listcreate();
extern void listadd();
extern void listfree();
extern unsigned hash_fn();
extern int is_number();

/* From wild.c */
extern int wild();
extern int wild_match();
extern int local_wild();
extern int local_wild_match();

/* From wiz.c */
extern void do_chownall();

/* From eval.c */
extern char *parse_to();
extern char *exec();
extern char *strip_braces();

#define XFUNCTION(x)   \
  void x(buff, args, nargs, privs, doer) \
     char *buff; \
     char *args[10]; \
     int nargs; \
     dbref privs; \
     dbref doer;

#define EV_FMAND   0x0100	/* text before () must be a function name */
#define EV_FCHECK  0x0200	/* cehck text before () for function name */
#define EV_STRIP   0x0400	/* strip a level of brackets */
#define EV_EVAL    0x0800	/* evaluate results before returning */

/* From boolexp.c */
extern int eval_boolexp();
extern struct boolexp *parse_boolexp();

/* From unparse.c */
#define unparse_object(p,x)		real_unparse(p,x,1)
#define object_header(p,x)		real_unparse(p,x,0)
extern const char *real_unparse();
extern const char *unparse_boolexp();

/* From destroy.c */
extern void free_object();

/* From compress.c */
#ifdef COMPRESS
extern const char *compress();
extern const char *uncompress();
extern void init_compress();
#endif				/* COMPRESS */

/* From chat.c */
#if (CHAT_SYSTEM >= 2)
extern void init_chat();
extern void do_channel();
extern void do_chat();
extern void do_chan_admin();
extern void do_channel_list();
extern channel_type find_channel();
extern const char *channel_name();
#endif                         /* CHAT_SYSTEM */

/* From db.c */
extern char *set_string();

extern char *wptr[10];

extern long random();

#ifndef i386
extern void srandom();
#endif

extern char *crypt();

#endif				/* __EXTERNS_H */
